<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use App\Models\Article;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\WithChunkReading;

class ArticlesExport implements FromCollection,WithHeadings,WithChunkReading
{
    public $dateFrom;
    public $dateTo;
    public $categoryId;
    public $subcategoryId;


    public function __construct($dateFrom = null,$dateTo = null,$categoryId = null,$subcategoryId = null)
    {
        $this->dateFrom = $dateFrom;
        $this->dateTo = $dateTo;
        $this->categoryId = $categoryId;
        $this->subcategoryId = $subcategoryId;

    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function headings():array{
        return[
            'url',
            'text id',
            'title',
            'body',
        ];
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $dateFrom =$this->dateFrom;
        $dateTo = $this->dateTo;
        $categoryId = $this->categoryId;
        $subcategoryId = $this->subcategoryId;

        //gradimo upit u zavisnosti od prosledjenih podataka
        $articles = Article::select('id','heading','text','category_id','subcategory_id');
        if(isset($dateFrom) && !empty($dateFrom) && !is_null($dateFrom)){
            $dateFrom = new Carbon($dateFrom);
            $articles = $articles->where('time_created','>=',$dateFrom);
        }
        if(isset($dateTo) && !empty($dateTo) && !is_null($dateTo)){
            $dateTo = new Carbon($dateTo);
            $articles = $articles->where('time_created','<=',$dateTo);
        }
        if(isset($categoryId) && !empty($categoryId) && $categoryId != 0){
            $articles = $articles->where('category_id',$categoryId);
        }
        if(isset($subcategoryId) && !empty($subcategoryId) && $subcategoryId != 0){
            $articles = $articles->where('subcategory_id',$subcategoryId);
        }
        $articles = $articles->orderBy('time_created','desc')->get();
        
        $exportArray = [];
        foreach($articles as $article){
            $body = "";
            $exportArticle['url'] = $article->getMainUrl();
            $exportArticle['text_id'] = $article->id;
            $exportArticle['title'] = $article->heading ?? '';
            if($article->id < 40401){
                $body = $article->text;
            }else{
                $lines = explode('</p>', stripslashes(strip_tags($article->text, '<span><aside><figure><figcaption><><blockquote><p><iframe><param><div><object><param><span><embed><table><thead><tbody><th><td><tr><img><br /><br><br/><p><h1><h2><h3><h4><h5><font><a><i><b><strong><em><u><ul><li><script>')));
                foreach($lines as $line){
                    $lines = explode("\n", $line);
                    $pregMatches = [];
                    foreach($lines as $line){
                        if(substr($line, 0, 3) === '<p>' || substr($line, 0, 3) === '<p>' ){
                            $body = $body.$line;
                        }
                    }
                }
            }
            $exportArticle['body'] = strip_tags($body);
            $exportArray[] = $exportArticle;
        }
        return collect($exportArray);
    }
    public function chunkSize(): int
    {
        return 100;
    }
}
