<?php

/**
 * Class
 *
 * PHP version 7.2
 *
 * @category   class
 * @copyright  2015-2018 Cubes d.o.o.
 * @license    GPL http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version    GIT: 1.0.0
 */

namespace App\Policies;

use Illuminate\Auth\Access\HandlesAuthorization;

use App\Auth\Section as Entity;
use App\Models\User;

class AuthSectionPolicy 
{
    use HandlesAuthorization;

    public function before(User $user, $ability)
    {
        // Common check for all policy actions
        // executed BEFORE any other action
        // ideally to enable super users

        return true;//remove this after copy!!!
    }
    
    public function access(User $user, Entity $entity)
    {
        if ($entity->getName() == 'admin') {
            return true;
        }
    }

    public function __call(string $action , array $arguments)
    {
        $user = $arguments[0];
        $entity = $arguments[1];
        if ($entity->getName() == 'admin') {
            return true;
        }
    }
}
