<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Priority\Priority;

class PrioritiesSeeder extends Seeder
{
    /*Prioriteti sajta */
    public $priorities = [
        
        [
            'group' => 'general',
            'type' => 'aktuelno',
            'title' =>  'Aktuelno',
            'visible' => 4,
            'limit' => 7
        ],
        [
            'group' => 'category',
            'type' => 'category',
            'title' =>  'Category',
            'visible' => 10,
            'limit' => 12
        ],
        [
            'group' => 'subategory',
            'type' => 'subcategory',
            'title' =>  'Subcategory',
            'visible' => 8,
            'limit' => 12
        ],
        [
            'group' => 'dobitnici_ninove_nagrade',
            'type' => 'dobitnici_ninove_nagrade',
            'title' =>  'Dobitnici Ninove nagrade',
            'visible' => 300,
            'limit' => 303
        ],
        [
            'group' => 'spisak-romana',
            'type' => 'spisak-romana',
            'title' =>  'Spisak romana',
            'visible' => 1,
            'limit' => 1
        ],
        
    ];
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /*Ukoliko navedeni prioritet vec postoji u bazi,
        nece biti dodat */
        foreach($this->priorities as $priority) {
            if(isset(Priority::where('title',$priority['title'])->get()->toArray()[0]['id'])
            && !empty(Priority::where('title',$priority['title'])->get()->toArray()[0]['id'])) {
                $id = Priority::where('title',$priority['title'])->get()->toArray()[0]['id'];
            }else {
                $id = '';
            }
            /*Ako postoji prioritet u bazi nastavi dalje */
            if(isset($id) && !empty($id)) {
                continue;
            }
            /*Kreiraj novi prioritet u bazi */
            Priority::create($priority);
            
           
        }
    }
}
