@if($websites->count() > 0)
<li 
    class="{{$websites->count() > 1 ? 'dropdown ' : ''}}user-box list-inline-item {{!empty($currentSection) && $currentSection == 'website' ? ' active' : ''}}"
>
    @if($websites->count() > 1)
    
    <a 
        href="{{empty($activeWebsite) ? '#' : route('website.index', ['website' => $activeWebsite->id])}}" 
        class="dropdown-toggle waves-effect user-link" data-toggle="dropdown" aria-expanded="true"
    >
        @if(!empty($activeWebsite))
        <i class="fa fa-paste"></i>
        <span>
            <span class="d-none d-lg-inline">@lang('Uredništvo'):</span>
            {{$activeWebsite->short_title}}
        </span>
        @else
        <i class="fa fa-paste"></i>
        <span class="d-none d-lg-inline">@lang('Uredništvo')</span>
        @endif
        <i class="fa fa-caret-down"></i>
    </a>
    <ul class="dropdown-menu arrow-dropdown-menu arrow-menu-right user-list notify-list">
        <li>
            <a class="dropdown-item" href="{{route('website.index', ['website' => $primaryWebsite->id])}}">
                <span>{{$primaryWebsite->title}}</span>
                @if($primaryWebsite->url)
                <span>({{$primaryWebsite->url}})</span>
                @endif
            </a>
        </li>
        @foreach($websites as $website)
        @continue(!empty($activeWebsite) && $activeWebsite->id == $website->id)
        @if($website->id != $primaryWebsite->id)
            <li>
                <a class="dropdown-item" href="{{route('website.index', ['website' => $website->id])}}">
                    <span>{{$website->title}}</span>
                    @if($website->url)
                    <span>({{$website->url}})</span>
                    @endif
                </a>
            </li>
        @endif
        @endforeach
    </ul>
    @else
    <a class="waves-effect user-link" href="{{route('website.index', ['website' => $websites->first()->id])}}">
        <i class="fa fa-paste"></i>
        <span>
            <span class="d-none d-lg-inline">@lang('Uredništvo')</span>
        </span>
    </a>
    @endif
</li>
@endif