@push('head_links')
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            @csrf
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Ime')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('first_name', 'is-invalid')" 
                        name="first_name" 
                        placeholder="@lang('Ime')" 
                        value="{{old('first_name', $entity->first_name)}}"
                    >
                    @formError(['field' => 'first_name'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Prezime')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('last_name', 'is-invalid')" 
                        name="last_name" 
                        placeholder="@lang('Prezime')" 
                        value="{{old('last_name', $entity->last_name)}}"
                    >
                    @formError(['field' => 'last_name'])
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Email')<sup>*</sup></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('email', 'is-invalid')" 
                        name="email" 
                        placeholder="@lang('Email')" 
                        value="{{old('email', $entity->email)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-at"></i>
                        </span>
                    </span>
                    @formError(['field' => 'email'])
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Telefon')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('phone', 'is-invalid')" 
                        name="phone" 
                        placeholder="@lang('Telefon')" 
                        value="{{old('phone', $entity->phone)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-phone"></i>
                        </span>
                    </span>
                    @formError(['field' => 'phone'])
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('JMBG')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('jmbg', 'is-invalid')" 
                        name="jmbg" 
                        placeholder="@lang('JMBG')" 
                        value="{{old('jmbg', $entity->jmbg)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-id-card-o"></i>
                        </span>
                    </span>
                    @formError(['field' => 'jmbg'])
                    
                </div>
            </div>
            
        </div>
        <div class="col-4 offset-1">
            {{-- slika --}}
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>
<script>
$(function() {
    
    $(document).ready(function() {
    $('#entity-form').validate({
        rules: {
            first_name: {
                required: true
            },
            last_name: {
                required: true
            },
            phone: {
                required: true,
                maxlength: 15
            },
            email: {
                required: true,
                email: true
            },
            jmbg: {
                required: true,
                maxlength: 13
            }
        },
        messages: {
            jmbg: {
                digits: "JMBG može sadržavati samo brojeve.",
                maxlength: "JMBG može sadržavati najviše 13 cifara."
            },
            phone: {
                digits: "Telefon može sadržavati samo brojeve.",
                maxlength: "Telefon može sadržavati najviše 15 cifara."
            }
        },
    });
});

});
</script>
@endpush