@push('head_links')
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-12 align-self-center">
            @csrf
            <div class="row">
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="control-label">@lang('Broj fakture')</label>
                        <input 
                            type="text" 
                            class="form-control @errorClass('id_invoice', 'is-invalid') enterable" 
                            name="id_invoice" 
                            placeholder="@lang('Broj Fakture')" 
                            value="{{old('id_invoice', $entity->id_invoice)}}"
                        >
                        @formError(['field' => 'id_invoice'])
                    </div>
                </div>
                <div class="col-lg-2">
                    <div class="form-group">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="form-group">
                        <label class="control-label">@lang('Firma')</label>
                        <select id="companySelect" name="company" class="form-control @errorClass('company', 'is-invalid') enterable">
                            <option value="0" disabled selected>@lang('Izaberi')</option>
                            @foreach($companies as $company)
                            <option value="{{$company->id}}" data-currency="{{$company->currency}}" @if(old('company', $entity->company) == $company->id) selected @endif>{{$company->name}}</option>
                            @endforeach
                        </select>
                        @formError(['field' => 'company'])
                    </div>
                </div>
            </div>

            <hr>
            @php
                if($entity->date_start){
                    $dateStart = date('d-m-Y', strtotime($entity->date_start));
                    $dateEnd = date('d-m-Y', strtotime($entity->date_end));
                }else{
                    $dateStart = '';
                    $dateEnd = '';
                }
            @endphp
            <div class="row">
                <div class="col-lg-6">
                    <div class="form-group row">
                        <label class="col-sm-3 control-label">@lang('Datum početka')</label>
                        <div class="col-sm-5">
                            <input
                                type="text"
                                class="form-control @errorClass('date_start', 'is-invalid') enterable"
                                name="date_start"
                                id="date_start"
                                placeholder="@lang('Datum')"
                                value="{{old('date_start', $dateStart)}}"
                            >
                            @formError(['field' => 'date_start'])
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="form-group row">
                        <label class="col-sm-3 control-label">@lang('Rok placanja')</label>
                        <div class="col-sm-5">
                            <input
                                type="text"
                                class="form-control @errorClass('date_end', 'is-invalid') enterable"
                                name="date_end"
                                id="date_end"
                                placeholder="@lang('Datum')"
                                value="{{old('date_end', $dateEnd)}}"
                            >
                            @formError(['field' => 'date_end'])
                        </div>
                    </div>
                </div>
            </div>
                  
            <hr>
            
            <div class="row">
                <div class="col-lg-6">
                    <div class="form-group">
                        <label for="text" class="col-sm-3 control-label">@lang('Napomena')</label>
                        <textarea id="text" name="text" placeholder="@lang('Napomena')" class="form-control @errorClass('text', 'is-invalid') enterable">{{ old('text', $entity->text) }}</textarea>
                        @formError(['field' => 'text'])
                    </div>
                </div>
                <div class="form-group col-lg-4">
                    <label class="control-label">@lang('Ukupan iznos za uplatu')</label>
                    <div class="input-group">
                        <input 
                            type="text" 
                            class="form-control @errorClass('price', 'is-invalid') enterable" 
                            name="price" 
                            placeholder="@lang('Iznos ukupno')" 
                            value="{{old('price', $entity->price)}}"
                        >
                        <div id="currencyDisplay" class="input-group-append" style="margin-left: 10px;">
                            <input type="hidden" name="currency" id="currency" value="{{old('currency', $entity->currency)}}">
                            <span class="input-group-text">
                                {{old('currency', $entity->currency)}}
                            </span>
                        </div>
                    </div>
                    @formError(['field' => 'price'])
                </div>
            </div>
        </div>
        <div class="col-4 offset-1">
            {{-- slika --}}
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>

<script>
    // Funkcija koja se poziva kada se izabere nova opcija
   
</script>

<script>
$(function() {
    
    $(document).ready(function() {

    $('#companySelect').on('change', function() {
        var selectedOption = $(this).find('option:selected');
        var currency = selectedOption.data('currency');

        // Ažuriramo data-currency atribut
        $('#currencyDisplay .input-group-text').text(currency);

        // Ažuriramo skriveno polje
        $('#currency').val(currency);
    });

    $.validator.addMethod("validDate", function(value, element) {
        return moment(value,"DD-MM-YYYY", true).isValid();
    }, "{{ __('Unesite validan format DD-MM-GGGG.') }}");
    $.validator.addMethod("greaterStart", function (value, element, params) {
        //Konvertujemo datume i vracamo error alp je dateStart manji od dateEnd
        var dateStart= $('#entity-form [name="date_start"]').val().split("-")
        dateStart = new Date(dateStart[2], dateStart[1] - 1, dateStart[0]);
        var dateEnd= $('#entity-form [name="date_end"]').val().split("-")
        dateEnd = new Date(dateEnd[2], dateEnd[1] - 1, dateEnd[0]);
        return this.optional(element) || dateStart <= dateEnd;
    },"{{ __('Mora biti veće od datuma početka.') }}");

    $('#entity-form').validate({
        rules: {
            id_invoice: {
                required: true
            },
            company: {
                required: true,
            },
            date_start: {
                required: true,
                validDate: true
            },
            date_end: {
                required: true,
                validDate: true,
                greaterStart: '[name="date_start"]'
            },
            driver: {
                required: true,
            },
            truck: {
                required: true,
            },
            price:{
                required: true
            },
        },
        messages: {
            
        }
    });

    $('select').select2({
        minimumResultsForSearch: -1
    });

    $('#date_start').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    $('#date_end').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    // $('#entity-form [name="date_start"]').on('change', function(e){
    //     e.preventDefault();
    //     let start = $('#entity-form [name="date_start"]').val();
    //     let split = start.split('-');
    //     let end10 = parseInt(split[2]) + 10;

    //     $('#entity-form [name="date_end"]').val(split[0] + '-' + split[1] + '-' + end10);

    // });
});

});
</script>
@endpush
