@push('head_links')
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            @csrf
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Ime')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('first_name', 'is-invalid')" 
                        name="first_name" 
                        placeholder="@lang('Ime')" 
                        value="{{old('first_name', $entity->first_name)}}"
                    >
                    @formError(['field' => 'first_name'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Prezime')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('last_name', 'is-invalid')" 
                        name="last_name" 
                        placeholder="@lang('Prezime')" 
                        value="{{old('last_name', $entity->last_name)}}"
                    >
                    @formError(['field' => 'last_name'])
                    
                </div>
            </div>
            @if(request()->segment(count(request()->segments())) != 'edit')
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Lozinka')<sup>*</sup></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="password" 
                        class="form-control @errorClass('password', 'is-invalid')" 
                        name="password" 
                        placeholder="@lang('Lozinka')" 
                        value="{{old('password', $entity->password)}}"
                    >
                    @formError(['field' => 'password'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Potvrda lozinke')<sup>*</sup></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="password" 
                        class="form-control @errorClass('password_confirmation', 'is-invalid')" 
                        name="password_confirmation" 
                        placeholder="@lang('Potvrda lozinke')" 
                        value=""
                    >
                    @formError(['field' => 'password_confirmation'])
                    
                </div>
            </div>
            @endif
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Email')<sup>*</sup></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('email', 'is-invalid')" 
                        name="email" 
                        placeholder="@lang('Email')" 
                        value="{{old('email', $entity->email)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-at"></i>
                        </span>
                    </span>
                    @formError(['field' => 'email'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Telefon')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('phone', 'is-invalid')" 
                        name="phone" 
                        placeholder="@lang('Telefon')" 
                        value="{{old('phone', $entity->phone)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-phone"></i>
                        </span>
                    </span>
                    @formError(['field' => 'phone'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Grupa korisnika')<sup>*</sup></label>
                <div class="col-sm-9">
                    <select id="users_group" name="users_group" class="form-control select2 select2-hidden-accessible @errorClass('users_group', 'is-invalid')")">
                        <option value="">@lang('Odaberite grupu za korisnika ...')</option>
                        
                        @foreach($usersGroups as $usersGroup)
                        <option value="{{ $usersGroup['id'] }}"
                            @if (old('users_group', in_array($usersGroup['id'], $currentUsersGroups))) selected @endif
                            >{{ $usersGroup['text']}}
                        </option>
                        @endforeach
                    </select>
                    @formError(['field' => 'users_group'])

                </div>
            </div>
        </div>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>
<script>
$(function() {
    $("#primary_website, #websites, #users_group").select2();
    
    //$('#websites_' + $('#primary_website').val()).attr("disabled", true);
    
    $('#primary_website').on('change', function(){
        $('.websites').removeAttr("disabled");
        $('#websites_' + $(this).val()).prop('checked', true);
        $('#websites_' + $(this).val()).attr("disabled", true);
    });
    
    $('#entity-form').validate({
        rules: {
            first_name:{
               required: true
            },
            last_name:{
               required: true
            },
            phone:{
            },
            password: {
                required: true,
            },
            password_confirm: {
                required: true,
            },
            email: {
                required: true,
                email: true
            },
            primary_website: {
                //required: true
            },
            websites: {
                required: true
            },
            users_group: {
                required: true
            }
            
        }
    });
});
</script>
@endpush