<?php $__env->startSection('head_title', __('Vesti') . ' - ' . __('Nova Vest')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Eksport vesti"),
    'breadcrumbs' => [
        route('articles.export_articles_page') => __('Eksport vesti')
    ]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
.article-content {
    position: relative;
    z-index: 9;
}
</style>
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-heading d-flex justify-content-between align-items-center">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Filteri za eksport vesti'); ?></h3>
                    <p class="card-sub-title text-muted"><?php echo app('translator')->get('Unesite zeljene filtere'); ?></p>
                </div>
            </div>
            <div class="card-body pt-1">
                <form action="<?php echo e(route('articles.export_articles_to_excel')); ?>" id="export-filters-form" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="control-label"><?php echo app('translator')->get('Datum od'); ?><sup>*</sup></label>
                                <div class="">
                                    <input
                                            type="text"
                                            class="form-control"
                                            name="date_from"
                                            placeholder="<?php echo app('translator')->get('Datum od'); ?>"
                                            id="date-from"
                                            value=""
                                            data-mask="9999-99-99 99:99"
                                            data-name="articleTimeCreated"
                                    >
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="control-label"><?php echo app('translator')->get('Datum do'); ?></label>
                                <div class="">
                                    <input
                                            type="text"
                                            class="form-control"
                                            name="date_to"
                                            placeholder="<?php echo app('translator')->get('Datum do'); ?>"
                                            id="date-to"
                                            value=""
                                            data-mask="9999-99-99 99:99"
                                            data-name="articleTimeCreated"
                                    >
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">

                        <div class="col-lg-3">
                            <div class="form-group">
                                <label class="control-label"><?php echo app('translator')->get('Kategorija'); ?></label>
                                <div class="">
                                    <?php
                                        $selectedMainCat = collect(json_decode($mainCategories, true))->filter(function($value, $key){
                                          return $value['id'] == old('category_id');
                                        })->first();
                                    ?>
                                    <select name="category_id" class="form-control select-category" data-website-id="0">
                                        <?php if(!empty($selectedMainCat) && count($selectedMainCat)): ?>
                                            <option value="<?php echo e($selectedMainCat['id']); ?>"><?php echo e($selectedMainCat['text']); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label class="control-label"><?php echo app('translator')->get('Potkategorija'); ?></label>
                                <div class="subcategory_select">
                                    <?php
                                        $selectedMainSubCat = collect(json_decode($mainSubCategories, true))->filter(function($value, $key){
                                          return $value['id'] == old('subcategory_id');
                                        })->first();
                                    ?>
                                    <select name="subcategory_id" class="form-control select-subcategory" data-website-id="0">
                                        <?php if(!empty($selectedMainSubCat) && count($selectedMainSubCat)): ?>
                                            <option value="<?php echo e($selectedMainSubCat['id']); ?>"><?php echo e($selectedMainSubCat['text']); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row justify-content-end">
                        <div class="col-12 d-flex flex-wrap justify-content-end">
                            <button type="submit" class="btn btn-sm btn-warning waves-effect waves-light ml-2">
                                <i class="fa fa-check-circle"></i>
                                <?php echo app('translator')->get('Eksportuj vesti'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
    <script>
        $(document).ready(function () {
            $('#export-filters-form [name="date_from"]').datepicker({format: 'yyyy-mm-dd'});
            $('#export-filters-form [name="date_to"]').datepicker({format: 'yyyy-mm-dd'});

            var updateSelect = function (element, jsonData, category = false, destroyElement = false) {
                let siteId = element.data('website-id');
                let data = jsonData.filter(function (n) {
                    if (category) {
                        return (n.site_id == siteId && n.parent_id == category) || n.id == 0;
                    } else {
                        return n.site_id == siteId;
                    }
                }).map(function (obj) {
                    return {
                        'id': obj.id,
                        'text': obj.text
                    }
                });

                if (destroyElement) {
                    destroyElement.select2('destroy').empty();
                    destroyElement.select2({
                        minimumResultsForSearch: -1,
                        data: data
                    });
                } else {
                    element.select2({
                        minimumResultsForSearch: -1,
                        data: data
                    });
                }
            };

            var mainCategories = JSON.parse('<?php echo $mainCategories; ?>');
            var mainSubcategories = JSON.parse('<?php echo $mainSubCategories; ?>');

            $('#export-filters-form select').each(function (key, item) {
                if ($(this).hasClass('select-category')) {
                    updateSelect($(this), mainCategories);

                } else if ($(this).hasClass('select-subcategory')) {
                    let siteId = $(this).data('website-id');
                    let selectedCategory = $('#export-filters-form select.select-category[data-website-id=' + siteId + ']').val();
                    updateSelect($(this), mainSubcategories, selectedCategory);

                }
            });

            $('#export-filters-form select.select-category').on('change', function (e) {
                let siteId = $(this).data('website-id');
                let category = $(this).val();
                updateSelect($(this), mainSubcategories, category, $('#export-filters-form select.select-subcategory[data-website-id=' + siteId + ']'));
            });
            $('#export-filters-form').validate({
                    rules: {
                        date_from: "required",
                    },
                    messages: {
                       date_from : "Obavezan je odabir datuma"
                    }
                });

        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/cms/resources/views/articles/export_articles.blade.php ENDPATH**/ ?>