<?php $__env->startSection('head_title', __('Izlana Faktura') . ' - ' . __('Kreiranje Fakture')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Kreiranje izlazne fakture"),
    'breadcrumbs' => [
        route('truck.invoices') => __('Izlazne Fakture')
    ]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
    .table th:nth-child(2), .table td:nth-child(2) {
        width: 50%; /* Širina druge kolone */
    }
    .table th:nth-child(3), .table th:nth-child(4), .table th:nth-child(5),
    .table td:nth-child(3), .table td:nth-child(4), .table td:nth-child(5) {
        width: 15%; /* Širina kolona za iznose */
    }
    
    .number-row {
        
    }

    .button-usluge {
        float: right;
        margin: 5px;
    }
</style>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Kreiranje nove izlazne fakture'); ?></h3>
                </div>
                <div class="card-heading-actions">
                    <a href="<?php echo e(route('truck.invoices')); ?>" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i>
                        <?php echo app('translator')->get('Nazad'); ?>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <form id="wizard-validation-form" action="#">
                                    <div>
                                        
                                        <h3>Usluge</h3>
                                        <section>
                                            <table class="table" id="invoiceTable">
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th>Naziv usluge</th>
                                                        <th>Iznos bez PDV-a</th>
                                                        <th>PDV %</th>
                                                        <th>Iznos ukupno</th>
                                                        <th class="no-print">Akcija</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <div class="form-group number-row">
                                                                1
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="form-group">
                                                                <input 
                                                                    type="text" 
                                                                    class="form-control <?= $errors->has("id_invoice") ? 'is-invalid' : ""; ?> enterable" 
                                                                    name="id_invoice" 
                                                                    placeholder="<?php echo app('translator')->get('Naziv Usluge'); ?>" 
                                                                    value="<?php echo e(old('id_invoice', $entity->id_invoice)); ?>"
                                                                >
                                                                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'id_invoice'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="form-group">
                                                                <input 
                                                                    type="text" 
                                                                    class="form-control <?= $errors->has("id_invoice") ? 'is-invalid' : ""; ?> enterable" 
                                                                    name="id_invoice" 
                                                                    placeholder="<?php echo app('translator')->get('100.00'); ?>" 
                                                                    value="<?php echo e(old('id_invoice', $entity->id_invoice)); ?>"
                                                                >
                                                                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'id_invoice'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                            </div>    
                                                        </td>
                                                        <td>
                                                            <div class="form-group">
                                                                <input 
                                                                    type="text" 
                                                                    class="form-control <?= $errors->has("id_invoice") ? 'is-invalid' : ""; ?> enterable" 
                                                                    name="id_invoice" 
                                                                    placeholder="<?php echo app('translator')->get('0.00'); ?>" 
                                                                    value="<?php echo e(old('id_invoice', $entity->id_invoice)); ?>"
                                                                >
                                                                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'id_invoice'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="form-group">
                                                                <input 
                                                                    type="text" 
                                                                    class="form-control <?= $errors->has("id_invoice") ? 'is-invalid' : ""; ?> enterable" 
                                                                    name="id_invoice" 
                                                                    placeholder="<?php echo app('translator')->get('100.00'); ?>" 
                                                                    value="<?php echo e(old('id_invoice', $entity->id_invoice)); ?>"
                                                                >
                                                                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'id_invoice'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                            </div>
                                                        </td>
                                                        <td class="no-print">
                                                            <div class="form-group">
                                                                <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">X</button>
                                                            </div>
                                                        </td> <!-- Dugme za uklanjanje reda -->
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </section>
                                        <h3>Step 3</h3>
                                        <section>
                                            <div class="form-group row">
                                                <div class="col-lg-12">
                                                    <ul class="list-unstyled w-list">
                                                        <li><b>First Name :</b> Jonathan </li>
                                                        <li><b>Last Name :</b> Smith </li>
                                                        <li><b>Emial:</b> jonathan@smith.com</li>
                                                        <li><b>Address:</b> 123 Your City, Cityname. </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </section>
                                        <h3>Step Final</h3>
                                        <section>
                                            <div class="form-group row">
                                                <div class="col-lg-12">
                                                    <input id="acceptTerms-2" name="acceptTerms2" type="checkbox" class="required">
                                                    <label for="acceptTerms-2">I agree with the Terms and Conditions.</label>
                                                </div>
                                            </div>

                                        </section>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')); ?>"></script>

<script>
    // Funkcija koja se poziva kada se izabere nova opcija
   
</script>

<script>
$(function() {
    
    $(document).ready(function() {

    $('#companySelect').on('change', function() {
        var selectedOption = $(this).find('option:selected');
        var currency = selectedOption.data('currency');

        // Ažuriramo data-currency atribut
        $('#currencyDisplay .input-group-text').text(currency);

        // Ažuriramo skriveno polje
        $('#currency').val(currency);
    });

    $.validator.addMethod("validDate", function(value, element) {
        return moment(value,"DD-MM-YYYY", true).isValid();
    }, "<?php echo e(__('Unesite validan format DD-MM-GGGG.')); ?>");
    $.validator.addMethod("greaterStart", function (value, element, params) {
        //Konvertujemo datume i vracamo error alp je dateStart manji od dateEnd
        var dateStart= $('#entity-form [name="date_start"]').val().split("-")
        dateStart = new Date(dateStart[2], dateStart[1] - 1, dateStart[0]);
        var dateEnd= $('#entity-form [name="date_end"]').val().split("-")
        dateEnd = new Date(dateEnd[2], dateEnd[1] - 1, dateEnd[0]);
        return this.optional(element) || dateStart <= dateEnd;
    },"<?php echo e(__('Mora biti veće od datuma početka.')); ?>");

    $('#entity-form').validate({
        rules: {
            id_invoice: {
                required: true
            },
            company: {
                required: true,
                date: true
            },
            date_start: {
                required: true,
                validDate: true
            },
            date_end: {
                required: true,
                validDate: true,
                greaterStart: '[name="date_start"]'
            },
            driver: {
                required: true,
            },
            truck: {
                required: true,
            },
            price:{
                required: true
            },
        },
        messages: {
            
        }
    });

    $('select').select2({
        minimumResultsForSearch: -1
    });

    $('#date_start').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    $('#date_end').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    // $('#entity-form [name="date_start"]').on('change', function(e){
    //     e.preventDefault();
    //     let start = $('#entity-form [name="date_start"]').val();
    //     let split = start.split('-');
    //     let end10 = parseInt(split[2]) + 10;

    //     $('#entity-form [name="date_end"]').val(split[0] + '-' + split[1] + '-' + end10);

    // });
    
});

});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/cms/resources/views/truck/invoices/invoice_up.blade.php ENDPATH**/ ?>