<style>
    .select-video-per-page{
    font-size: 12px;
    margin: 10px;
    }

    #select-video-filter{
            display: inline-block; 
            padding-left: 35%; 
            width: 50%;
        }

    

    @media (max-width: 900px) {
        #select-video-filter{
            display: inline-block; 
            padding-left: 25%; 
            width: 50%;
        }
    }

    @media (max-width: 560px) {
        #select-video-filter{
            display: inline-block; 
            padding-left: 15%; 
            width: 50%;
        }
    }

    @media (max-width: 360px) {
        #select-video-filter{
            display: inline-block; 
            padding-left: 10%; 
            width: 50%;
        }
    }

    @media (min-width: 1200px) {
        .video-fast-entry{
            margin-left: 25%;
            max-width: 25%;
        }
    }
</style>
<div id="leadVideoModal" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" style="box-shadow: 5px 10px #313a46; border-radius: 10px;">
            <div class="modal-header">
                <h3 class="modal-title"><?php echo app('translator')->get('Ubaci video'); ?></h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body pb-0 pt-0">
                <form class="form-horizontal" method="post" action="" role="form" id="lead_video_form"
                    enctype="multipart/form-data" autocomplete="off">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" value="" name="entityIds">
                    
                    
                    <div class="row m-b-10 d-flex flex-wrap justify-content-start m-t-15">
                        <div class="col-6">
                            <input type="search" class="form-control m-b-10" name="search_video" placeholder="<?php echo app('translator')->get('Unesite termin za pretragu'); ?>">
                            <button class="btn btn-primary" type="button" data-action="submit-form"><?php echo app('translator')->get('Pretraži'); ?></button> 
                        </div>
                        <div class="video-fast-entry col-5 d-flex flex-wrap justify-content-end">
                            <input class="form-control quick-video-entry" placeholder="Brzi unos - BRID ID" value="">
                        </div>
                    </div>
                </form>
                <hr>
                
                <div style="background-color: #4a4a4a; height: 50px; border-bottom: 4px solid #949494">
                    <div class="m-t-10" style="width: 48%; display: inline-block; ">
                        <span class="h4" style="margin-left: 15px; color: white;"><?php echo app('translator')->get('Video snimci'); ?></span>
                    </div>
                    
                    <div id="select-video-filter">
                        <select class="select-video-per-page" name="articles_number">
                            <option value="10">10 <?php echo app('translator')->get('Videos'); ?></option>
                            <option value="25">25 <?php echo app('translator')->get('Videos'); ?></option>
                            <option value="50">50 <?php echo app('translator')->get('Videos'); ?></option>
                        </select>

                        
                    </div>
                </div>
                    <fieldset style="overflow-y: scroll; height:400px;">
                        <div id="videos">
                            
                        </div>
                    </fieldset>
            </div>
        </div>
        
    </div>
</div>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(url('/theme/plugins/jquery-toastr/jquery.toast.min.js')); ?>"></script>
<script>
    function getBridVideoModal(){

        window['bridVideoModalInstance'] = window.hasOwnProperty('bridVideoModalInstance') ? window['bridVideoModalInstance'] : new ModalManagement({
                modal_selector: $('#leadVideoModal'),
                form_selector: $('#lead_video_form'),
                form_rules: {
                    
                },
                form_fill_on_ajax: false,
                ajax_getOne: "",
                ajax_getAll: '',
                ajax_create: "",
                ajax_update: "",
                ajax_delete: ''
            }).onCloseModal(function () {
                $('#leadVideoModal').off('click.MyVideoEvent');
                $('#leadVideoModal').off('keypress.MyKeyPressEvent');
            });
            return window['bridVideoModalInstance'];
    }
    
    $(document).ready(function() {
        var loaderHtml = `<div class='video-articles-loader m-t-10'">
                                <div class='text-center'>
                                    <img src="<?php echo e(url('/loader.gif')); ?>" alt=''/>
                                </div> 
                            </div>`;

        function checkModalType(){
            let leadVideoModal = $('#leadVideoModal').attr('data-action');
            if(leadVideoModal === 'ckeditorVideoModal'){
                return 'ckeditorVideoModal';
            }
            return 'formVideoModal';
        }

        //AJAX CALL FOR VIDEOS BY ID
        function getVideo(id){
            $.ajax({
                url: "<?= route('articles.get_brid_video'); ?>",
                type: "get",
                data: {
                    videoId: id
                }
            }).done(function(response){
                if(response.hasOwnProperty('error')){
                    showSystemMessage(response.error, 'error'); 
                }else{
                    let modal = $('#leadVideoModal');
                    modal.modal('hide');
                    $('.lead_video_wrapper').html(response);
                }
            }).fail(function(jqXHR, textStatus, errorThrowns){
                // showSystemMessage(jqXHR.responseJSON.errors.videoId[0], 'error')
            });
        }

        //GET SEARCHED VIDEOS
        function getSearchedVideos(term, videosNumber, page, bridId = false){
            $.ajax({
                url: "<?= route('articles.get_searched_videos'); ?>",
                type: "get",
                data: {
                    term: term,
                    videosNumber: videosNumber,
                    page: page,
                    search_brid: bridId
                }
            }).done(function(response) {
                $('#leadVideoModal div.video-articles-loader').hide();
                if(typeof(response) === 'object' && response.error.length > 0){
                    $('#leadVideoModal #videos').html("<p><?php echo app('translator')->get('Nije pronadjen nijedan video'); ?></p>");
                    showSystemMessage(response.error, 'error')
                }else{
                    $('#leadVideoModal #videos').html(response);
                }
                
            }).fail(function(jqXHR, textStatus, errorThrown){
                $('#leadVideoModal #videos').html("<p><?php echo app('translator')->get('Nije pronadjen nijedan video'); ?></p>");
            });
        }

        //CHECK IF VIDE HAS ALREADY BEEN ADDED
        //RETURN TRUE IF EXISTS
        function checkIfLeadVideoExists(){
            let videoId =  $('#leadVideoInput').val();
            if(!videoId){
                return false;
            }
            return true;
        }

        //ON CLICK GET PARAMETERS AND CALL AJAX
        $('#leadVideoModal button[data-action="submit-form"]').on('click', function(e){
            let term = $('#leadVideoModal input[name="search_video"]').val();
            let videosNumber = $('#leadVideoModal [name="articles_number"]').val();
            let page = $('#leadVideoModal [name="page"]').val();
            $('#videos').html(loaderHtml);
            getSearchedVideos(term, videosNumber, page);
        });

        //NA PROMENU BROJA VESTI PO STRANI POZIV AJAX-A
        $('#leadVideoModal [name=articles_number]').on('change', function(e){
            if($('#leadVideoModal').children().length > 0){
                $('#videos').html(loaderHtml);
                let term = $('#leadVideoModal input[name="search_video"]').val();
                let videosNumber = $('#leadVideoModal [name="articles_number"]').val();
                let page = $('#leadVideoModal [name="page"]').val();
                
                getSearchedVideos(term, videosNumber, page);
            }
        });

        //PAGINATION
        $('#leadVideoModal').on('click', '.pagination a', function(e) {
            e.preventDefault();
            let term = $('#leadVideoModal input[name="search_video"]').val();
            let videosNumber = $('#leadVideoModal [name="articles_number"]').val();
            let page = $(this).data('page');

            $('#videos').html(loaderHtml);
            getSearchedVideos(term, videosNumber, page);
        });

        //EVENT ON CLICK 'Ubaci'
        $('#leadVideoModal').on('click', 'div.list-videos-actions a', function(e){
            e.preventDefault();
            if(checkModalType() === 'formVideoModal'){
                if(checkIfLeadVideoExists()){
                showSystemMessage('Vec postoji dodat video, uklonite stari da biste dodali novi!', 'error');
                }else{
                    let id = $(this).data('video-id');
                    getVideo(id);
                }
            }
        });

        //"BRZI UNOS" - ON ENTER
        $('input.quick-video-entry').keypress(function(e) {
            let code = e.keyCode || e.which;
            if (code == 13) {
                if(checkModalType() === 'formVideoModal'){
                    if(checkIfLeadVideoExists()){
                    showSystemMessage('Vec postoji dodat video, uklonite stari da biste dodali novi!', 'error');
                    }else{
                        // window.location.href = "http://localhost:1111/articles" + "/" + $(this).val() + "/edit";
                        //stara logika za brzi unos
                        // getVideo($(this).val());
                        let term = $(this).val();
                        let videosNumber = $('#leadVideoModal [name="articles_number"]').val();
                        let page = $('#leadVideoModal [name="page"]').val();
                        $('#videos').html(loaderHtml);
                        getSearchedVideos(term, videosNumber, page, true);
                    }
                }
                
            }
        });

        $('#leadVideoModal input[name="search_video"]').keypress(function(e) {
            let code = e.keyCode || e.which;
            if (code == 13) {
                let term = $('#leadVideoModal input[name="search_video"]').val();
                let videosNumber = $('#leadVideoModal [name="articles_number"]').val();
                let page = $('#leadVideoModal [name="page"]').val();
                $('#videos').html(loaderHtml);
                getSearchedVideos(term, videosNumber, page);
            }
        });
        //pri zatvaranju dodaj atribut indikator da je modal za ckeditor
        //pri otvaranju iz forme dodaje se indikator da se  radi o modalu za formu
        $('#leadVideoModal').on('click', 'button.close', function(e){
            $('#leadVideoModal').attr('data-action', 'ckeditorVideoModal')
        });
        
    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/articles/partials/modals/lead_video.blade.php ENDPATH**/ ?>