<?php $__env->startPush('head_links'); ?>
<link href="<?php echo e(asset('/theme/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<div class="row fileinput fileinput-new" data-provides="fileinput" id="<?php echo e($id ?? $id = 'image_upload_' . rand(1000, 9999)); ?>">
    <div class="col-lg-6">
        <label><?php echo e($label ?? __('Slika')); ?></label>
    </div>
    <div class="col-lg-6 text-right">
        <span class="btn btn-outline-primary btn-file">
            <span class="fileinput-new">
                <?php if(!empty($imageObj)): ?>
                <?php echo app('translator')->get('Promeni sliku'); ?>
                <?php else: ?>
                <?php echo app('translator')->get('Izaberi sliku'); ?>
                <?php endif; ?>
            </span>
            <span class="fileinput-exists"><?php echo app('translator')->get('Druga slika'); ?></span>
            <input type="file" name="<?php echo e($name ?? $id); ?>" <?php if(isset($form)): ?> form="<?php echo e($form); ?>" <?php endif; ?> class="">
        </span>
        <span class="btn btn-secondary fileinput-exists" data-dismiss="fileinput"><?php echo app('translator')->get('Odustani'); ?></span>
        <?php if(!empty($imageObj)): ?>
        <span 
            class="btn btn-outline-danger"
            data-action="delete-photo"
            data-title="<?php echo app('translator')->get('Brisanje slike'); ?>"
            data-text="<?php echo app('translator')->get('Da li ste sigurni da želite da obrišete sliku?'); ?>"
            data-image-class="<?php echo e($imageObj->class); ?>"
            <?php if(isset($deleteImageAjaxUrl)): ?>
            data-ajax-url="<?php echo e($deleteImageAjaxUrl); ?>"
            <?php endif; ?> 
        ><?php echo app('translator')->get('Obriši'); ?></span>
        <?php endif; ?>
    </div>
    <div class="col-lg-12 text-center mt-4">
        <div class="fileinput-new img-thumbnail d-flex mx-auto" style="width: <?php echo e($width ?? '100'); ?>px; height: <?php echo e($height ?? '100'); ?>px;">
            <img data-src="<?php echo e(!empty($imageObj) ? $imageObj->getUrl() : $defaultImageUrl); ?>"  
                src="<?php echo e(!empty($imageObj) ? $imageObj->getUrl() : $defaultImageUrl); ?>" 
                alt="..."
                data-max-size="<?php echo e(config('newscms.max_image_upload_size')); ?>" 
                class="align-self-center">
        </div>
        <div class="fileinput-preview fileinput-exists img-thumbnail" style="max-width: <?php echo e($width ?? '100'); ?>px; max-height: <?php echo e($height ?? '100'); ?>px;"></div>
    </div>
</div>

<?php $__env->startPush('footer_scripts'); ?>
<script>
(function () {
    
    var blade = {
        default_image_url : "<?php echo e($defaultImageUrl); ?>"
    };


    var fileInput = $('input[name="<?php echo e($name ?? $id); ?>"]');

    // Zbog dodatih klasa 'd-flex' i 'mx-auto' "jasny" ne moze da postavi 'd-none' na
    // staru sliku nakon promene. Zato se te klase brisu nakon odabira druge slike.
    // 'd-flex' i 'mx-auto' zajedno sa 'align-self-center' centriraju sliku.
    fileInput.on('change', function() {
        $('#<?php echo e($id); ?>').find('.fileinput-new.img-thumbnail.d-flex.mx-auto')
                     .removeClass('d-flex')
                     .removeClass('mx-auto');
    });
    
    $('#<?php echo e($id); ?>').questionPop({
        liveSelector: '[data-action="delete-photo"]'
    }).on('success.qp', function (e) {
        let fileSelectContainer = $(e.target).closest('[data-provides="fileinput"]');
    
        fileSelectContainer.fileinput('reset');
        let origImage = fileSelectContainer.find('.fileinput-new img');
        console.log(origImage);
    
        origImage.attr('src', blade.default_image_url);
        origImage.data('src', blade.default_image_url);
        $(e.target).hide();
    });
  
})();
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/_layout/partials/form/image_upload.blade.php ENDPATH**/ ?>