<?php $__env->startSection('head_title', __('Ulazne Fakture') . ' - ' . __('Fakture')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Ulazne Fakture"),
    'breadcrumbs' => [
        route('truck.invoices_procurement') => __('Ulazne Fakture')
    ]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>

    .dropdown-menu {
        padding: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    }
    .dropdown-menu .dropdown-item {
        margin-bottom: 5px;
    }
    .dropdown-menu .dropdown-item:last-child {
        margin-bottom: 0;
    }
    .dropdown-menu .dropdown-item i {
        margin-right: 8px;
    }

    #entity-list-table thead th:first-child.sorting::after,
    #entity-list-table thead th:first-child.sorting_asc::after,
    #entity-list-table thead th:first-child.sorting_desc::after {
        display: none;
    }

    #entity-list-table th:nth-child(3),
    #entity-list-table td:nth-child(3) {
        max-width: 220px; 
        overflow: hidden;
        text-overflow: ellipsis; 
        white-space: nowrap; 
    }
    .date-highlight {
        padding: 5px;
        border-radius: 5px;
        display: inline-block;
    }
    .date-red {
        background-color: red;
        color: white;
    }
    .date-yellow {
        background-color: yellow;
        color: black;
    }
    .date-green {
        background-color: green;
        color: white;
    }
    .summary-box {
        padding: 20px;
        border-radius: 10px;
        color: black;
        text-align: center;
        font-size: 20px;
    }

    .summary-box {
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        background: #f8f9fa;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .summary-eur {
        background-color: white;
    }
    .summary-km {
        background-color: white;
    }
    .summary-rsd {
        background-color: white;
    }
</style>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Lista ulaznih faktura'); ?></h3>
                </div>
                <div class="card-heading-actions">
                    <a href="<?php echo e(route('truck.invoices_procurement_create')); ?>" class="btn btn-primary">
                        <i class="fa fa-plus"></i>
                        <?php echo app('translator')->get('Kreiraj fakturu'); ?>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class=""><?php echo app('translator')->get('ID'); ?></th>
                                <th class=""><?php echo app('translator')->get('Firma'); ?></th>
                                <th class=""><?php echo app('translator')->get('Opis'); ?></th>
                                <th class=""><?php echo app('translator')->get('Datum kreiranja'); ?></th>
                                <th class=""><?php echo app('translator')->get('Rok placanja'); ?></th>
                                <th class=""><?php echo app('translator')->get('Iznos'); ?></th>
                                <th class="disabled-sorting text-right"><?php echo app('translator')->get('Opcije'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="summary-box summary-km">
            <div>Fakture u valuti KM</div>
            
            <div class="text-danger"><?php echo app('translator')->get('Ukupno'); ?>: <span id="pending-km">0</span> KM</div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="summary-box summary-eur">
            <div>Fakture u valuti EUR</div>
            
            <div class="text-danger"><?php echo app('translator')->get('Ukupno'); ?>: <span id="pending-eur">0</span> EUR</div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="invoiceProcurementModal" tabindex="-1" role="dialog" aria-labelledby="invoiceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div style="background-color: white !important;" class="modal-header">
                <h5 style="color:black;" class="modal-title" id="invoiceModalLabel">Pregled Fakture</h5>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Zatvori</button>
            </div>
            <div class="modal-body">
                <iframe id="invoiceFrame" src="" style="width: 100%; height: 800px; border: none;"></iframe>
            </div>
            <div class="modal-footer">
                
                
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script>
$(function() {
    
    var blade = {
        datatablesAjaxUrl: "<?= route('truck.invoices_procurement_datatable'); ?>",
    };

    // Function to update summary values
    function updateSummary() {
        $.ajax({
            url: "<?php echo e(route('truck.invoices_procurement_summary')); ?>",
            type: "GET",
            dataType: "json",
            success: function(response) {
                // Update summary values for KM
                $('#pending-km').text(response.pending.km);
                // Update summary values for EUR
                $('#pending-eur').text(response.pending.eur);
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    }

    // Call the updateSummary function on document ready
    updateSummary();

    // DATATABLES
    $('#entity-list-table').DataTable({
        "autoWidth": true,
        "processing": true,
        "serverSide": true,
        "language": {
            "search": "Unesite broj fakture:"
        },
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
        },
        "columns": [
            {"data": "id_invoice", orderable: false, "className": ""},
            {"data": "company", orderable: false, "className": ""},
            {"data": "text", orderable: false, "className": ""},
            {"data": "date_start", orderable: false, searchable: false, "className": ""},
            {"data": "date_end", orderable: false, searchable: false, "className": ""},
            {"data": "price", orderable: false, "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
        "order": [[0, "asc"]],
        "rowCallback": function(row, data, index) {
            var today = moment();
            var dateEnd = moment(data.date_end, 'DD-MM-YYYY'); // Adjust the date format to match your data

            // Reset any previous highlighting
            $('td:eq(4)', row).removeClass('date-red date-yellow date-green');

            // Add the appropriate class based on the date condition
            if (data.status == 1) {
                $('td:eq(4)', row).html('<span class="date-highlight date-green">' + data.date_end + '</span>');
            } else if (today.isSameOrAfter(dateEnd, 'day')) {
                $('td:eq(4)', row).html('<span class="date-highlight date-red">' + data.date_end + '</span>');
            } else if (today.isSameOrAfter(dateEnd.subtract(7, 'days'), 'day')) {
                $('td:eq(4)', row).html('<span class="date-highlight date-yellow">' + data.date_end + '</span>');
            } else {
                $('td:eq(4)', row).html(data.date_end);
            }
        }
    });


    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };

    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
        updateSummary(); // Update the summary after deletion
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/truck/invoices_procurement/index.blade.php ENDPATH**/ ?>