<?php

namespace App\Http\Controllers\Traits;

use App\Models\FormAutosave;
use Illuminate\Database\Eloquent\Model;

trait FormAutosaveTrait
{

    public function populateAutosave($entity)
    {
        if($this->hasAutosave($entity)){
            $autosaveData = $this->getAutosave($entity);
            if($entity instanceof Model){
                $entity = $this->populateModel($entity, $autosaveData);
            }else {
                $entity = $this->populateForm($entity, $autosaveData);
            }
        }
        return $entity;
    }

    public function populateModel($entity, $autosaveData)
    {
        $entity->fill($autosaveData);

        return $entity;
    }

    public function populateForm($entity, $autosaveData)
    {
        $entity = array_merge($entity, $autosaveData);

        return $entity;
    }

    
    public function getAutosave($entity)
    {
        
        $formAutosave = $this->autosaveQuery($entity)->first();

        return $formAutosave ? $formAutosave->form_data : [];
    }

    public function hasAutosave($entity)
    {
        return !empty($this->getAutosave($entity));
    }

    public function deleteAutosave($entity)
    {
        $this->autosaveQuery($entity)->delete();
    }

    protected function autosaveQuery($entity)
    {
        $formAutosaveQuery = FormAutosave::where('form_type', $this->formType)->where('user_id', auth()->user()->id);

        if($entity instanceof Model && $entity->exists){
            $formAutosaveQuery->where('form_entity_id', $entity->id);
        }
        return $formAutosaveQuery;
    }

}