<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use \App\Models\Utils\ImageableTrait;
    
    protected $table = "settings";
    
    protected $with = ['images'];

    protected $fillable = ['key', 'value'];

    public $timestamps = FALSE;
    
    protected $imageResizeRecepies = [
        "slika_logo" => [
            [
                "type" => "resize",
                "w" => 500
            ],
            [
                "type" => "fit",
                "w" => 192,
                "h" => 120
                // setovane su dimenzije kao sto ima 'codefox.png'. Print dimenzije su 192x120
            ]
        ],
        "slika_app_logo" => [
            [
                "type" => "resize",
                "w" => 500
            ],
            [
                "type" => "fit",
                "w" => 322,
                "h" => 56
            ]
        ],
        "slika_icon" => [
            [
                "type" => "resize",
                "w" => 96 
            ],
            [
                "type" => "fit",
                "w" => 64,
                "h" => 64 
            ]
        ]
    ];

    /*
     * Vrati 'public URL' do logo slike ukoliko firma ima 
     * logo sliku. Ukoliko nema, vrati 'default'-nu sliku.
     */
    public static function getLogoImg()
    {
        if(setting('admin.logo')) {
            return setting('admin.logo');
        }

        return config('newscms.default_logo_img_src');
    }

    /*
     * Vrati 'public URL' do 'icon' slike ukoliko firma ima 
     * 'icon' sliku. Ukoliko nema, vrati 'default'-nu sliku.
     */
    public static function getIconImg()
    {
        if(setting('admin.icon')) {
            return setting('admin.icon');
        }

        return config('newscms.default_icon_img_src');
    }

    /*
     * Vrati 'public URL' do 'app_logo' slike ukoliko firma ima 
     * 'app_logo' sliku. Ukoliko nema, vrati 'default'-nu sliku.
     */
    public static function getAppLogoImg()
    {
        if(setting('admin.app_logo')) {
            return setting('admin.app_logo');
        }

        return config('newscms.default_logo_img_src');
    }
}
