<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Pages extends Model
{

    use SoftDeletes;

    protected $table = 'pages';

    protected $fillable = ['title', 'description', 'text', 'with_sidebar' ];
    

    const ACTIVE = 1;
    const INACTIVE = 0;

    public function delete()
    {
        $this->deleted_by = \Auth::user()->id;
        $this->save();
        return parent::delete(); // TODO: Change the autogenerated stub
    }
    public static function boot()
    {
        parent::boot();
        static::creating(function ($model) {
            $user = \Auth::user();
            $model->created_by = $user->id;
            $model->updated_by = $user->id;
        });
        static::updating(function ($model) {
            $user = \Auth::user();
            $model->updated_by = $user->id;
        });
    }

    public function isActive()
    {
        return !$this->ban;
    }

    public function getImageUrl()
    {
        if(empty($this->image)){
            return $this;
        }

        $removeParth = '/opt/public';
        
        $parthForURL = str_replace($removeParth, '', $this->image);

        $imageUrl = url($parthForURL);

        return $imageUrl;
    }
    
    public function getMainUrl()
    {
        return config('newscms.frontend_url') . '/stranice/' . $this->id . '/' . \Str::slug($this->title);
    }
}
