<?php

namespace App\Models\Truck;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use App\Models\User;


class InvoicePayment extends Model
{
    use SoftDeletes;
    protected $table = 'truck_invoice_payments';

    protected $fillable = [
        'text', 
        'company', 
        'price', 
        'reference',
        'date_start',
        'currency'];

protected static function boot()
{
    parent::boot();

    static::creating(function ($model) {
        $model->created_by = Auth::id();
        $model->updated_by = Auth::id();
    });

    static::updating(function ($model) {
        $model->updated_by = Auth::id();
    });
}

public function creator()
{
    return $this->belongsTo(User::class, 'created_by');
}

public function updater()
{
    return $this->belongsTo(User::class, 'updated_by');
}
    
public function company()
{
    return $this->belongsTo(Company::class, 'company_id');
}
}
