<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace App\Models\Utils;

/**
 * Izmenjen originalan ActiveInactiveModel tako da dozvoljava izmenu imena
 * ciljne kolone u tabeli baze podataka i dozvoljava izmenu vrednosti 'active' 
 * i 'inactive'.
 * Klasa koja koristi ovaj 'trait' ne treba da implementira ActiveInactive interfejs.
 *
 * @author aleksa
 */
trait ActiveInactiveModelModifyable
{
    protected function getActiveField()
    {
        return 'active';
    }

    public static function getActiveValue()
    {
        return 1;
    }

    public static function getInactiveValue()
    {
        return 0;
    }
    
    public function isActive(): bool
    {
        return $this->{$this->getActiveField()} == static::getActiveValue();
    }
    
    public function isInactive(): bool
    {
        return $this->{$this->getActiveField()} == static::getInactiveValue();
    }
    
    public function scopeActive($query)
    {
        $query->where(
            $this->getTable() . '.' . $this->getActiveField(), 
            static::getActiveValue()
        );
    }
    
    public function scopeInactive($query)
    {
        $query->where(
            $this->getTable() . '.' . $this->getActiveField(), 
            static::getInactiveValue()
        );
    }
}
