<?php

namespace Database\Seeders;

use App\Models\ComicCategory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ComicCategorySeed extends Seeder
{
    /*Prioriteti sajta */
    public $categories = [      
        [
            'name' => 'KIBICFENSTER',
            'slug' => 'kibicfenster'
        ],
        [
            'name' => 'TAČKA. RAZNO',
            'slug' => 'tacka-razno'
        ],
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /*Ukoliko navedeni prioritet vec postoji u bazi,
        nece biti dodat */
        foreach($this->categories as $category) {
            if(isset(ComicCategory::where('name',$category['name'])->get()->toArray()[0]['id'])
            && !empty(ComicCategory::where('name',$category['name'])->get()->toArray()[0]['id'])) {
                $id = ComicCategory::where('name',$category['name'])->get()->toArray()[0]['id'];
            }else {
                $id = '';
            }
            /*Ako postoji prioritet u bazi nastavi dalje */
            if(isset($id) && !empty($id)) {
                continue;
            }
            /*Kreiraj novi prioritet u bazi */
            ComicCategory::create($category);
        }
    }
}
