/* 
 * Javascript fajl predvidjen kao zajednicki za sve 'view'-eve
 */


/*
 * 
 * questionPop interface:
 * 
 * $(element).quesitonPop(options);
 * 
 * @param      char $
 * @returns    {JQuery.Node}
 */
(function($) {
    
    /**
     * Konstruktorska funkcija za prikazivanje 'da/ne' dijaloga i opciono
     * mogucnost 'Ajax' poziva.
     * 
     * PAZNJA 'dependencies': Swal, jQuery
     * 
     * @param Object options {
     *            string title
     *            string htmlQuestion
     *            string yestText
     *            string noText
     *            string type
     *            string ajaxUrl
     *            object ajaxParams
     *        }
     */
    function QuestionPop(options, $t) {

        let settings = {};
        $.extend(true, settings, options, $t.data());
        this.settings = settings;

        // standardni Javaskript 'hack' za vidljivost promenljivih unutar 
        // sub-funkcija/objekta koristeci this.that
        this.that = {};
        this.that.settings = this.settings;
        this.that.$t = $t;
        
        this.fire = () => {
            
            Swal.fire({
                title: this.settings['title'],
                type: this.settings['type'],
                html: this.getHtmlQuestion(),
                showCancelButton: true,
                cancelButtonClass: 'btn btn-light',
                cancelButtonText: this.settings['noText'],
                confirmButtonClass: 'btn btn-danger',
                confirmButtonText: this.settings['yesText'],
                onOpen: function() {
                    $('#swal-datepicker').datepicker({
                        startView: 0,
                        todayHighlight: true,
                        autoclose: true,
                        format: "dd.mm.yyyy"
                    }).datepicker("setDate", new Date());
                },
                preConfirm: () => {
                    if(this.settings['datepicker'] && this.settings['url']){
                        var val = moment( $('#swal-datepicker').val(), 'DD.MM.YYYY').format('YYYY-MM-DD');
                        this.that.$t[0].form.action = this.settings['url'] + '/' + val;
                    }
                }
            }).then((result) => {
                
                if (!result.value) { // 'no' was clicked by the user
                    this.that.$t.trigger('cancel.qp');
                    return false;
                }

                if(this.settings['ajaxUrl']) {
                    let ajaxParams = {
                        'url': this.that.settings['ajaxUrl'],
                        'type': 'post',
                        'data': this.that.settings['ajaxParams'] ? this.that.settings['ajaxParams'] : {}
                    };
                    $.ajax(ajaxParams)
                     .done((response) => {
                        var message = response['message'] ? response['message'] : 'OK';

                        this.that.$t.trigger('success.qp');

                        if(this.that.settings['showSystemMessage']) {
                            showSystemMessage(message);
                        }
                    });
                }
                else {
                    this.that.$t.trigger('success.qp');
                }

            });
        }
    }
    
    /*
     * Construct HTML question
     * 
     * Return 'htmlQuestion' if it's set in settings
     * Return string constructed from 'text' and 'label' if no 'htmlQuestion' is
     * specified
     * 
     * @return string (HTML)
     */
    QuestionPop.prototype.getHtmlQuestion = function() {
        
        let boldSpecifier = "#~b~#";
        
        if (this.settings['htmlQuestion']) {
            return this.settings['htmlQuestion'];
        }
        else if(this.settings['text']) {
            
            let boldText = '';
            let datepicker = '';
            
            if(this.settings['label']) {
                boldText = '<b>' + this.settings['label'] + '</b>';
            }
            
            if(this.settings['datepicker']) {
                datepicker = this.settings['datepicker'];
            }
            
            if (this.settings['text'].indexOf(boldSpecifier) !== -1) {
                return this.settings['text'].replace(boldSpecifier, boldText);
            }
            
            return this.settings['text'] + boldText + datepicker;
        }
        return 'Da li ste sigurni da želite da izvršite ovu akciju?';
    };
    
    
	/**
     *  @param   object params
     *  @param   function callback
     *  @returns jquery.node
     */
	$.fn.questionPop = function(options, callback=null) {

		// merge default and user parameters
        var parameters = $.extend(true, {}, $.fn.questionPop.defaults, options);
        
        if(parameters['liveSelector'] != undefined) {
            this.on('click', parameters.liveSelector, function() {
                var $t = $(this);
                if(callback) callback($t, parameters);
                $.fn.questionPop.instantiate(parameters, $t);
            });
        }
        else {
            this.on('click', function() {
                var $t = $(this);
                if(callback) callback($t, parameters);
                $.fn.questionPop.instantiate(parameters, $t);
            });
        }

		// allow jQuery chaining
		return this;
	};
	
	$.fn.questionPop.defaults = {
        'title': 'Izvrši ovu akciju',
        'yesText': 'Da',
        'noText': 'Ne',
        'type': 'warning',
        'callAjax': false,
        'showSystemMessage': false
    };
    
    $.fn.questionPop.instantiate = (parameters, $t) => {
        let qp = new QuestionPop(parameters, $t);
        return qp.fire();
    };

})(jQuery);


(function($) {

    $.fn.multiItemsControl = function(options, arg) {
        if (typeof(options) == 'undefined') {
            options = {};
        }

        //this is initialization
        if (options && typeof(options) == 'object') {
            options = $.extend( {}, $.fn.multiItemsControl.defaults, options );


            this.each(function() {
                new $.fn.multiItemsControl.init($(this), options);
            });

            return this;
        }

        //this is function call like $('something').multiItemsControl('add');
        switch (options) {
            case 'add':
                return $.fn.multiItemsControl.add($(this), arg);
            case 'remove':
                return $.fn.multiItemsControl.remove($(this), arg);
            case 'clear':
                return $.fn.multiItemsControl.clear($(this));
            default:
                throw Error('First argument of plugin function call is invalid');
        }
    };

    $.fn.multiItemsControl.init = function (elem, options) {
        let elementOptions = $.extend({}, options, elem.data());

        elem.data('multiItemsControl', elementOptions);
        //console.log(elementOptions);
        //ensure that element has this data-toggle attribute
        elem.attr('data-toggle', 'multi-items-control');

        elem.on('click', '[data-action="remove-item"]', function (e) {
            e.preventDefault();
            let itemToRemove = $(this).closest('[data-toggle="item-container"]');

            elem.multiItemsControl('remove', itemToRemove);
        });

        elem.on('click', '[data-action="add-item"]', function (e) {
            e.preventDefault();
            let itemToClone = $(this).closest('[data-toggle="item-container"]');

            elem.multiItemsControl('add', itemToClone);
        });

        elem.on('click', '[data-action="clear-items"]', function (e) {
            e.preventDefault();
            elem.multiItemsControl('clear');
        });

        return elem;
    };

    $.fn.multiItemsControl.add = function (elem, itemToClone) {
        let elementOptions = elem.data('multiItemsControl');

        let maxItems = elementOptions['maxItems'] ? elementOptions['maxItems'] : 0;

        if (maxItems && elem.find('[data-toggle="item-container"]').length >= maxItems) {
            //console.log('Max elements reached!');
            return elem.find('[data-toggle="item-container"]').last();
        }

        let item;

        if (itemToClone instanceof jQuery) {
            item = itemToClone.clone();
        } else if (
            !isNaN(itemToClone) 
            && itemToClone >= 0 
            && elem.find('[data-toggle="item-container"]').length > itemToClone
        ) {
            item = elem.find('[data-toggle="item-container"]').get(itemToClone).clone();
        } else {
            item = elem.find('[data-toggle="item-container"]').last().clone();
        }

        elem.append(item);

        if (elementOptions['clearInputs']) {
            item.find('input:not(:button):not(:checkbox):not(:radio):not(:submit),textarea,select').val('');
        }

        return item;
    };

    $.fn.multiItemsControl.remove = function (elem, itemToRemove) {
        let elementOptions = elem.data('multiItemsControl');

        let minItems = elementOptions['minItems'] ? elementOptions['minItems'] : 1;
        if (minItems < 1) {
            minItems = 1;
        }

        if (elem.find('[data-toggle="item-container"]').length <= minItems) {
            console.log('Min elements reached!');
            return;
        }

        let item;

        if (
            itemToRemove instanceof jQuery) {
            item = itemToRemove;
        } else if (
            !isNaN(itemToRemove) 
            && itemToRemove >= 0 
            && elem.find('[data-toggle="item-container"]').length > itemToRemove
        ) {
            item = elem.find('[data-toggle="item-container"]').get(itemToRemove);
        } else {
            item = elem.find('[data-toggle="item-container"]').last();
        }

        item.remove();

        return elem;
    };

    $.fn.multiItemsControl.clear = function (elem) {
        let elementOptions = elem.data('multiItemsControl');
        let items = elem.find('[data-toggle="item-container"]');

        items.each(function (i) {
            elem.multiItemsControl('remove', items.length - i - 1);
        });

        if (elementOptions['clearInputs']) {
            elem.find('input:not(:button):not(:checkbox):not(:radio):not(:submit),textarea,select').val('');
        }

        return elem;
    };

    $.fn.multiItemsControl.defaults = {
        clearInputs: true
    };
})(jQuery);

(function ($) {
    $.fn.disableInputControl = function(options, arg) {
        if (typeof(options) == 'undefined') {
            options = {};
        }

        //this is initialization
        if (options && typeof(options) == 'object') {
            options = $.extend( {}, $.fn.disableInputControl.defaults, options );


            this.each(function() {
                new $.fn.disableInputControl.init($(this), options);
            });

            return this;
        }

        //this is function call like $('something').multiItemsControl('add');
        switch (options) {
            case 'disable':
                return $.fn.disableInputControl.disable($(this));
            case 'enable':
                return $.fn.disableInputControl.enable($(this));
            default:
                throw Error('First argument of plugin function call is invalid');
        }
    };

    $.fn.disableInputControl.init = function (elem, options) {
        let elementOptions = $.extend({}, options, elem.data());

        let inputField = elem.find('[data-toggle="disable-input-field"]');

        //save element placeholder and value
        elementOptions['oldInputValue'] = inputField.val();
        elementOptions['oldInputPlaceholder'] = inputField.attr('placeholder');
        
        //save element options into element data
        //console.log('init');
        //console.log(elementOptions);
        elem.data('disableInputControl', elementOptions);
        
        //ensure that element has this data-toggle attribute
        elem.attr('data-toggle', 'disable-input-control');

        elem.on('click', '[data-action="disable-input-toggle"]', function (e) {
            
            e.stopPropagation();

            let toggleElem = $(this).is(':checkbox') ? $(this) : $(this).find(':checkbox');

            let disabled = toggleElem.prop('checked');

            if (disabled) {
                elem.disableInputControl('disable');
            } else {
                elem.disableInputControl('enable');
            }
            
            return elem;
        });

        
        //disable element on init
        let toggleElement = elem.find('[data-action="disable-input-toggle"]');
        
        if (!toggleElement.is(':checkbox')) {
            toggleElement = toggleElement.find(':checkbox');
        }

        if (toggleElement.prop('checked')) {
            $.fn.disableInputControl.disable(elem);
        } else {
            $.fn.disableInputControl.enable(elem);
        }
    };

    $.fn.disableInputControl.disable = function (elem, options) {
        let elementOptions = elem.data('disableInputControl');
        
        let inputField = elem.find('[data-toggle="disable-input-field"]');

        //save element placeholder and value
        elementOptions['oldInputValue'] = inputField.val();
        elementOptions['oldInputPlaceholder'] = inputField.attr('placeholder');

        //console.log('disable');
        //console.log(elementOptions);
        elem.data('disableInputControl', elementOptions);

        //disable element
        inputField.prop('disabled', true);

        //set disabled state placeholder if any
        if (elementOptions['placeholder']) {
            inputField.attr('placeholder', elementOptions['placeholder']);
        }
        //clear value if that is an option
        if (elementOptions['clearValue']) {
            inputField.val('');
        }

        return elem;
    };

    $.fn.disableInputControl.enable = function (elem, options) {
        let elementOptions = elem.data('disableInputControl');
        //console.log('enable');
        //console.log(elementOptions);
        let inputField = elem.find('[data-toggle="disable-input-field"]');

        //enable element
        inputField.prop('disabled', false);

        //restore old placeholder
        inputField.attr('placeholder', elementOptions['oldInputPlaceholder']);
        //restore old value if it has been cleared
        if (elementOptions['clearValue']) {
            //restore old  value
            inputField.val(elementOptions['oldInputValue']);
        }

        return elem;
    };

    $.fn.disableInputControl.defaults = {
        'placeholder': '',
        'clearValue': true
    };
})(jQuery);

(function ($) {
    Number.decimalni_broj = function (number) {
        return this.parseFloat(number).toFixed(2).toLocaleString();
    };
})(jQuery);


/**
 *  Plugin for the tags selec2 and their crud
 * 
 *  @param      char $
 *  @returns    {JQuery.Node}
 */
(function($) {
	/**
     *  @param   object params
     *  @returns jquery.node
     */
	$.fn.tagsSelect = function(options) {
		// merge default and user parameters
        var parameters = $.extend(true, {}, $.fn.tagsSelect.defaults, options);
		var select2Config = {
			multiple: parameters.multiple,
			maximumSelectionLength: parameters.maximumSelectionLength,
			placeholder: parameters.placeholder,
			width: '100%',
			ajax: {
				url: parameters.sourceUrl,
				dataType: 'json',
				type: 'POST',
				delay: 1000
			}
		};

		if(parameters['dropdownParent']) {
			select2Config.dropdownParent = parameters['dropdownParent'];
		}
		
		if (parameters.enableCreate) {
			select2Config.tags = true;
			
			select2Config.createTag = function (params) {
				var term = $.trim(params.term);
                                
				if (term === '') {
				  return null;
				}

				return {
				  id:       0,
				  text:     term + parameters.newTagLabel,
				  textOriginal: term,
				  newTag:   true
				};
			};
			
			select2Config.templateSelection = function (state) {
				if (!state['newTag']) {
					return state.text;
				}
				
				return $(`<span class="text-danger"> ${state.text}</span>`);
			};
		}
		// traverse all nodes
		this.each(function() {

			// express a single node as a jQuery object
			var $t = $(this);
            
            // mambo-jambo ...
            $t.select2(select2Config);
			
			if (!parameters.enableCreate) {
				//enableCreate is false just finish configuring
				return;
			}
			
			//enableCreate is true
			$t.on('select2:select', function (e) {
				//e.stopPropagation();
				//e.preventDefault();

				var tag = e.params.data;
                                
				if (!tag['newTag']) {
					//selected tag is not new tag just return
					return;
				}
				var data = $t.select2('data');
			
				for(var index in data) {
					if (data[index]['newTag']) {
						data.splice(index, 1);
						continue;
					}
				}

                                // clean up select2 options 
				$.fn.tagsSelect.setSelect2Options($t, data, true);
				
				//new tag was selected call handleStoring and show form
				$.fn.tagsSelect.handleStoringTag(0, tag['textOriginal'], function(newTag) {
					//remove selected "(NEW)" tag
					var data = $t.select2('data');
					data.push(newTag);
					
					$.fn.tagsSelect.setSelect2Options($t, data, true);
					
				}, parameters);
			});
                        
                        if(parameters['value']) {
                                var $t = $(this);
                                var vals = parameters['value'];
                                $.fn.tagsSelect.setSelect2Options($t, vals, true);
                        }
                        
                        
                        // pick from most used tags
                        if(parameters['mostUsedTags']) {
                                var $t = $(this);
                                var mostUsedTags = parameters['mostUsedTags'];
                                
                               $('.most-used-tags').on('click', function () {
                                    var tagId = $(this).attr('data-id');
                                    var data = $t.select2('data');
                                    
                                    if(data.find(x => x.id == tagId)){
                                        return ;
                                    }
                                    
                                    var tag = mostUsedTags.find(x => x.id == tagId);
                                    
                                    data.push(tag);
                                    
                                    $.fn.tagsSelect.setSelect2Options($t, data, true);
                                });
                        }
		});
                
		// allow jQuery chaining
		return this;
	};
	
	$.fn.tagsSelect.defaults = {
            multiple: true,
                    maximumSelectionLength: 0,
                    placeholder: null,
            sourceUrl: '/tags/populate-search', 
                    storeUrl: '/tags/store',
                    enableCreate: true,
                    newTagLabel: ' (NEW TAG)',
                    translations: {
                cancel: 'No, Cancel!',
                submit: 'Submit',
                tags_form_title: 'Tag Settings',
                successful_save: 'Tag successfully saved',
                error_title: 'Ooops..',
                error_text: 'Looks like something went wrong'
            },
                    csrfToken: $('meta[name="csrf-token"]').attr('content'),
                    showSystemMessageOnCreate: true
        };
	
	$.fn.tagsSelect.setSelect2Options = function($t, data, triggerChange) {
		$t.empty();
		var selectedTagIds = [];
		for(var index in data) {
			$t.append(new Option(data[index]['text'], data[index]['id'], false, false));
			selectedTagIds.push(data[index]['id']);
		}
                
		$t.select2('data', data);
		$t.val(selectedTagIds);

		// trigger change just in case ;)
		if (triggerChange) {
			$t.trigger('change');
		}
	};
	
	$.fn.tagsSelect.handleStoringTag = function (tagId, tagText, successHandler, options) {
		var parameters = $.extend(
			true,
            {}, 
            $.fn.tagsSelect.defaults, 
            options
		);
		
		let ajaxCall = function(title) {
			// do ajax submit of tags form
			$.ajax({
				url: parameters.storeUrl,
				method: 'post',
				data: {
					title: title
				},
				success: function(data) {
                                    if(parameters['showSystemMessageOnCreate']) {
                                            showSystemMessage(data['message']);
                                    }
                                    
                                    if((parameters['datatables'])) {
                                            $('#' + parameters['datatables']).DataTable().draw();
                                    } else {
                                            console.log('No datatables to reload');
                                    }

                                    if (typeof successHandler == 'function') {
                                            successHandler({
                                                    'id': data['data']['id'],
                                                    'text': data['data']['title'] + ' (Novi tag)'
                                            });
                                    }
				},
			});
		}
                
                ajaxCall(tagText);
	};
})(jQuery);