@push('head_links')
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<div class="row fileinput fileinput-new" data-provides="fileinput" id="{{$id ?? $id = 'file_upload_' . rand(1000, 9999)}}">
    <div class="col-lg-5">
        <label>{{$label ?? __('Fajl')}}</label>
    </div>
    <div class="col-lg-7 text-right">
        <span class="btn btn-outline-primary btn-file">
            <span class="fileinput-new">
                @if(!empty($fileObj))
                @lang('Promeni fajl')
                @else
                @lang('Izaberi fajl')
                @endif
            </span>
            <span class="fileinput-exists">@lang('Drugi fajl')</span>
            <input type="file" name="{{$name ?? $id}}" @isset($form) form="{{$form}}" @endisset class="">
        </span>
        <span class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">@lang('Odustani')</span>
        @if(!empty($fileObj))
        <span 
            class="btn btn-outline-danger"
            data-action="delete-file"
            data-title="{{$deleteTitle ?? __('Brisanje fajla')}}"
            data-text="{{$deleteText ?? __('Da li ste sigurni da želite da obrišete fajl ')}} '{{ $fileObj->name }}' ?"
            @if(isset($deleteFileAjaxUrl))
            data-ajax-url="{{$deleteFileAjaxUrl}}"
            @endif 
        >@lang('Obriši')</span>
        @endif
    </div>
    <div class="col-lg-12 text-center mt-4 file-preview-container">
        <div class="fileinput-new">
            @if(!empty($fileObj))
            <a href="{{$fileObj->fileUrl()}}" download class="d-block text-left">
                <small class="float-right pt-1">({{$fileObj->fileSize(true)}})</small>
                <i class="fa fa-download"></i>
                <small>{{$fileObj->name}}</small>
            </a>
            @else
            <span class="text-muted">{{$labelLong ?? __('Izaberite faj') . (!empty($label) ? ' ' .  __('za') . ' ' . $label : '')}}</span>
            @endif
        </div>
        <div class="fileinput-exists p-2 text-left">
            <i class="fa fa-upload"></i>
            <div class="fileinput-preview d-inline-block text-danger" style="max-width: 100%; max-height: 100px;"></div>
        </div>
    </div>
</div>

@push('footer_scripts')
<script>
(function () {
    
    var blade = {
        'select_file_long_label': "{{$labelLong ?? __('Izaberite faj') . (!empty($label) ? ' ' .  __('za') . ' ' . $label : '')}}"
    };
    
    $('#{{$id}}').questionPop({
        liveSelector: '[data-action="delete-file"]'
    }).on('success.qp', function (e) {
        let fileSelectContainer = $(e.target).closest('[data-provides="fileinput"]');
    
        fileSelectContainer.fileinput('reset');

        let origFile = fileSelectContainer.find('.file-preview-container .fileinput-new');
    
        origFile.empty();
        origFile.append('<span class="text-muted">' + blade.select_file_long_label + '</span>');

        $(e.target).hide();
    });
  
})();
</script>
@endpush