<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
      @csrf
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Naziv statičke stranice')<sup>*</sup></label>
        <div class="col-sm-9">
            <input 
                type="text" 
                class="form-control @errorClass('name', 'is-invalid')" 
                name="title" 
                placeholder="@lang('Naziv')" 
                value="{{old('name', $entity->title)}}"
                data-index="1"
            >
            @formError(['field' => 'title'])
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Opis')</label>
        <div class="col-sm-9">
            <textarea 
                class="form-control @errorClass('biography', 'is-invalid')" 
                name="description" 
                placeholder="@lang('Opis')"
                data-index="2" 
            >{{old('biography', $entity->description)}}</textarea>
            @formError(['field' => 'description'])
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Stranica sa sidebar-om')<sup>*</sup></label>
        <div class="col-lg-9">
            <select name="with_sidebar"class="form-control @errorClass('with_sidebar', 'is-invalid') enterable">
                <option value="1" @if(old('with_sidebar', $entity->with_sidebar) == 1) selected @endif>@lang('da')</option>
                <option value="0" @if(old('with_sidebar', $entity->with_sidebar) == 0) selected @endif>@lang('ne')</option>
            </select>
            @formError(['field' => 'with_sidebar'])
        </div>
    </div>
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Slika')</label>
        <div class="col-sm-9">
            <input 
                type="file" 
                class="form-control filestyle @errorClass('photo', 'is-invalid')" 
                name="photo" 
                placeholder="@lang('Slika')"
                data-index="3"
            >
            @formError(['field' => 'photo'])
        </div>
    </div>
    @if($entity->image)
    <div class="form-group row">
        <label class="col-sm-3 control-label">@lang('Prikaz Slike')</label>
        <div class="col-sm-9">
        <img src="{{$entity->getImageUrl()}}" width="450" height="450">
        </div>
    </div>
    @endif
    <hr>
    
    @include('pages.partials.form.content')
    
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light" id="button" data-index="4">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script type="text/javascript" src="{{url('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script>
$('#entity-form').validate({
    "rules": {
        "title": {
            required: true,
            maxlength: 50
        },
        "description": {
            required: false,
            maxlength: 65000
        },
        "with_sidebar": {
            required: true
        },
    }
});
$(document).on("keypress", 'form', function (e) {
    let code = e.keyCode || e.which;

    let $this = $(e.target);
    let index = parseFloat($this.attr('data-index'));
    
    if (code == 13) {

        e.preventDefault();

        if($this.attr('type') == 'submit'){
            $this.click();
        }

        let input = $('[data-index="' + (index + 1).toString() + '"]');

        input.focus();

        if(input.attr('type') == 'file'){
            input.click();

        }
        
    }
});

</script>

@endpush