<div class="card">
    <div class="card-heading d-flex justify-content-between">
        <div class="card-heading-title">
            <h3 class="card-title">@lang('Lista PDF fajlova')</h3>
            <p class="card-sub-title text-muted">@lang('Postoji <code>pretraga</code> liste')</p>
        </div>
        <div class="card-heading-actions">
            
        </div>
    </div>
    <div class="card-body">
        <table id="entities-table" class="table table-striped">
            <thead>
                <tr>
                    <th class="text-center"><span class="text-success"><i class="fa fa-check"></i></span></th>
                    <th>@lang('Naziv PDF fajla')</th>
                    <th class="text-right">@lang('Akcije')</th>
                </tr>
            </thead>

        </table>
    </div>
</div>

@push('footer_scripts')
<script>
$(function(){

    $('#entities-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: "@route('pdf.datatable')",
            type: "POST",
            data: {entityId: "{{$entity->id}}"}
        },
        "columns": [
            {"data": "ban", className: "text-center"},
            {"data": "name"},
            {"data": "actions", "searchebale": false, "orderable": false, className: "text-right"}
        ]
    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="delete"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="enable"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="disable"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });


});
</script>
@endpush