@extends('_layout.layout')

@section('head_title', __('Vozila') . ' - ' . __('Vozila'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Kreiranje vozila"),
    'breadcrumbs' => [
        route('truck.trucks') => __('Vozila')
    ]
])

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Kreiranje novog vozila')</h3>
                    <p class="card-sub-title text-muted">@lang('Polja sa * su obavezna')</p>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('truck.trucks')}}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i>
                        @lang('Nazad')
                    </a>
                </div>
            </div>
            <div class="card-body">
                @include('truck.trucks.partials.form', ['entity' => $entity])
            </div>
        </div>
    </div>
</div>

@endsection
