<?php

namespace App\Http\Controllers;

//change the request class if needed
use Illuminate\Http\Request as Request;

use App\Models\Truck\Invoice as Entity;
use App\Models\Truck\Procurement as InvPro;
use App\Models\Website\Website;

use Junges\ACL\Models\Group;

use App\Http\Resources\Select2\Role;
use Illuminate\Validation\Rule;

use App\Http\Resources\JsonResource;
use App\Models\Truck\Company;
use App\Models\Truck\CompanyProcurement;
use App\Models\Truck\Driver;
use App\Models\Truck\Truck;
use Illuminate\Support\Carbon;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class TruckReportsController extends Controller 
{
    protected $request;
    
    public function __construct(Request $request)
    {
        $this->request = $request;

    }
    
    public function index()
    {   
        $companies = Company::all();
        $drivers = Driver::all();
        $trucks = Truck::all();

        return view('truck.reports.invoices.index', [
            'companies' => $companies,
            'drivers' => $drivers,
            'trucks' => $trucks
        ]);

    }

    public function indexProcurement()
    {   
        $companies = CompanyProcurement::all();

        return view('truck.reports.invoices_procurement.index', [
            'companies' => $companies,
        ]);

    }
    
    public function datatable(Request $request)
    {
        $query = Entity::query()->with(['drivers', 'trucks'])->where('id', '>', 0)->orderBy('created_at', 'desc');

        // Apply date range filter
        if ($request->has('date_start') && $request->date_start) {
            $date = \DateTime::createFromFormat('d-m-Y', $request->date_start);
            if ($date) {
                $formattedDate = $date->format('Y-m-d');
                $query->where('date_start', '>=', $formattedDate);
            } else {
                return response()->json(['error' => 'Invalid start date format'], 400);
            }
        }

        if ($request->has('date_end') && $request->date_end) {
            $date = \DateTime::createFromFormat('d-m-Y', $request->date_end);
            if ($date) {
                $formattedDate = $date->format('Y-m-d');
                $query->where('date_start', '<=', $formattedDate);
            } else {
                return response()->json(['error' => 'Invalid end date format'], 400);
            }
        }

        if ($request->has('driver') && $request->driver) {
            $query->whereHas('drivers', function ($q) use ($request) {
                $q->where('driver_id', $request->driver);
            });
        }

        if ($request->has('company') && $request->company) {
            $query->where('company', $request->company);
        }

        if ($request->has('status') && isset($request->status)) {
            $query->where('status', $request->status);
        }
            
        $sumEUR = $this->calculateCurrencySums($query, 'EUR');


        // Reset query for datatables
        $query = Entity::query()->with(['drivers', 'trucks'])->where('id', '>', 0)->orderBy('created_at', 'desc');

        // Apply date range filter
        if ($request->has('date_start') && $request->date_start) {
            $date = \DateTime::createFromFormat('d-m-Y', $request->date_start);
            if ($date) {
                $formattedDate = $date->format('Y-m-d');
                $query->where('date_end', '>=', $formattedDate);
            } else {
                return response()->json(['error' => 'Invalid start date format'], 400);
            }
        }

        if ($request->has('date_end') && $request->date_end) {
            $date = \DateTime::createFromFormat('d-m-Y', $request->date_end);
            if ($date) {
                $formattedDate = $date->format('Y-m-d');
                $query->where('date_end', '<=', $formattedDate);
            } else {
                return response()->json(['error' => 'Invalid end date format'], 400);
            }
        }

        if ($request->has('driver') && $request->driver) {
            $query->whereHas('drivers', function ($q) use ($request) {
                $q->where('driver_id', $request->driver);
            });
        }

        if ($request->has('company') && $request->company) {
            $query->where('company', $request->company);
        }

        if ($request->has('status') && isset($request->status)) {
            $query->where('status', $request->status);
        }
        $sumKM = $this->calculateCurrencySums($query, 'KM');
    // Reset query for datatables
    $query = Entity::query()->with(['drivers', 'trucks'])->where('id', '>', 0)->orderBy('created_at', 'desc');

    // Apply date range filter
    if ($request->has('date_start') && $request->date_start) {
        $date = \DateTime::createFromFormat('d-m-Y', $request->date_start);
        if ($date) {
            $formattedDate = $date->format('Y-m-d');
            $query->where('date_end', '>=', $formattedDate);
        } else {
            return response()->json(['error' => 'Invalid start date format'], 400);
        }
    }

    if ($request->has('date_end') && $request->date_end) {
        $date = \DateTime::createFromFormat('d-m-Y', $request->date_end);
        if ($date) {
            $formattedDate = $date->format('Y-m-d');
            $query->where('date_end', '<=', $formattedDate);
        } else {
            return response()->json(['error' => 'Invalid end date format'], 400);
        }
    }

    if ($request->has('driver') && $request->driver) {
        $query->whereHas('drivers', function ($q) use ($request) {
            $q->where('driver_id', $request->driver);
        });
    }

    if ($request->has('company') && $request->company) {
        $query->where('company', $request->company);
    }

    if ($request->has('status') && isset($request->status)) {
        $query->where('status', $request->status);
    }
        $datatables = datatables($query)
            ->addColumn('actions', function ($entity) {
                return view('truck.reports.invoices.table.actions', 
                            ['entity' => $entity]);
            })
            ->editColumn('price', function ($entity) {
                if ($entity->price_part > 0) {
                    return $entity->price . ' (<span class="price-part-green">' . $entity->price_part . '</span>) ' . $entity->currency;
                } else {
                    return $entity->price . ' ' . $entity->currency;
                }
                
            })->editColumn('company', function ($entity) {
                $company = Company::where('id', $entity->company)->first();    
                return $company['name'];  
            })->editColumn('drivers', function ($entity) {
                $drivers = $entity->drivers()->withTrashed()->get();
                $driverNames = $drivers->map(function ($driver) {
                    return $driver->first_name . ' ' . $driver->last_name;
                });
                
                return $driverNames->implode('<br>');
            })->editColumn('trucks', function ($entity) {
                $trucks = $entity->trucks()->withTrashed()->get();
                
                $plateNumbers = $trucks->map(function ($truck) {
                    return $truck->number_of_plates;
                })->toArray();
                
                // Grupisanje u parove
                $grouped = array_chunk($plateNumbers, 2);
                
                // Kreiranje stringa sa parovima i dodavanje <br> svakog trećeg reda
                $output = [];
                foreach ($grouped as $index => $pair) {
                    $output[] = implode(' / ', $pair);
                    if (($index + 1) % 3 == 0) {
                        $output[] = '<br>';
                    }
                }
                
                return rtrim(implode('<br>', $output), '<br>'); 
            })->editColumn('date_start',function($entity){
                $date = Carbon::parse($entity->date_start);
                return $date->format('d-m-Y');
            })->editColumn('date_end',function($entity){
                $date = Carbon::parse($entity->date_end);
                return $date->format('d-m-Y');
            })->rawColumns(['actions', 'image', 'trucks', 'drivers', 'price'])
            ->setRowAttr([
                'data-id' => function($entity) {
                    return $entity->id;
                }
            ])
            ->make(true);

        $datatables = $datatables->getData(true);
        $datatables['sumEUR'] = $sumEUR;
        $datatables['sumKM'] = $sumKM;

        return response()->json($datatables);
    }    

public function datatableProcurement(Request $request)
{
    $query = InvPro::query()->where('id', '>', 0)->orderBy('created_at', 'desc');

    // Apply date range filter
    if ($request->has('date_start') && $request->date_start) {
        $date = \DateTime::createFromFormat('d-m-Y', $request->date_start);
        if ($date) {
            $formattedDate = $date->format('Y-m-d');
            $query->where('date_end', '>=', $formattedDate);
        } else {
            return response()->json(['error' => 'Invalid start date format'], 400);
        }
    }

    if ($request->has('date_end') && $request->date_end) {
        $date = \DateTime::createFromFormat('d-m-Y', $request->date_end);
        if ($date) {
            $formattedDate = $date->format('Y-m-d');
            $query->where('date_end', '<=', $formattedDate);
        } else {
            return response()->json(['error' => 'Invalid end date format'], 400);
        }
    }

    if ($request->has('driver') && $request->driver) {
        $query->where('driver', $request->driver);
    }

    if ($request->has('company') && $request->company) {
        $query->where('company', $request->company);
    }

    if ($request->has('status') && isset($request->status)) {
        $query->where('status', $request->status);
    }
        
    $sumEUR = $this->calculateCurrencySums($query, 'EUR');


    // Reset query for datatables
    $query = InvPro::query()->where('id', '>', 0)->orderBy('created_at', 'desc');

    // Apply date range filter
    if ($request->has('date_start') && $request->date_start) {
        $date = \DateTime::createFromFormat('d-m-Y', $request->date_start);
        if ($date) {
            $formattedDate = $date->format('Y-m-d');
            $query->where('date_end', '>=', $formattedDate);
        } else {
            return response()->json(['error' => 'Invalid start date format'], 400);
        }
    }

    if ($request->has('date_end') && $request->date_end) {
        $date = \DateTime::createFromFormat('d-m-Y', $request->date_end);
        if ($date) {
            $formattedDate = $date->format('Y-m-d');
            $query->where('date_end', '<=', $formattedDate);
        } else {
            return response()->json(['error' => 'Invalid end date format'], 400);
        }
    }

    if ($request->has('driver') && $request->driver) {
        $query->where('driver', $request->driver);
    }

    if ($request->has('company') && $request->company) {
        $query->where('company', $request->company);
    }

    if ($request->has('status') && isset($request->status)) {
        $query->where('status', $request->status);
    }
    $sumKM = $this->calculateCurrencySums($query, 'KM');
// Reset query for datatables
$query = InvPro::query()->where('id', '>', 0)->orderBy('created_at', 'desc');

// Apply date range filter
if ($request->has('date_start') && $request->date_start) {
    $date = \DateTime::createFromFormat('d-m-Y', $request->date_start);
    if ($date) {
        $formattedDate = $date->format('Y-m-d');
        $query->where('date_end', '>=', $formattedDate);
    } else {
        return response()->json(['error' => 'Invalid start date format'], 400);
    }
}

if ($request->has('date_end') && $request->date_end) {
    $date = \DateTime::createFromFormat('d-m-Y', $request->date_end);
    if ($date) {
        $formattedDate = $date->format('Y-m-d');
        $query->where('date_end', '<=', $formattedDate);
    } else {
        return response()->json(['error' => 'Invalid end date format'], 400);
    }
}

if ($request->has('driver') && $request->driver) {
    $query->where('driver', $request->driver);
}

if ($request->has('company') && $request->company) {
    $query->where('company', $request->company);
}

if ($request->has('status') && isset($request->status)) {
    $query->where('status', $request->status);
}
    $datatables = datatables($query)
        ->addColumn('actions', function ($entity) {
            return view('truck.reports.invoices_procurement.table.actions', 
                        ['entity' => $entity]);
        })
        ->editColumn('price', function ($entity) {
            return $entity->price .' '. $entity->currency;
        })->editColumn('company', function ($entity) {
            $company = CompanyProcurement::where('id', $entity->company)->first();    
            return $company['name'];  
        })->editColumn('date_start',function($entity){
            $date = Carbon::parse($entity->date_start);
            return $date->format('d-m-Y');
        })->editColumn('date_end',function($entity){
            $date = Carbon::parse($entity->date_end);
            return $date->format('d-m-Y');
        })->rawColumns(['actions', 'image'])
        ->setRowAttr([
            'data-id' => function($entity) {
                return $entity->id;
            }
        ])
        ->make(true);

    $datatables = $datatables->getData(true);
    $datatables['sumEUR'] = $sumEUR;
    $datatables['sumKM'] = $sumKM;

    return response()->json($datatables);
}

public function calculateCurrencySums($query, $currency)
{
    // Kopirajte originalni upit
    $queryCopy1 = clone $query;
    $queryCopy2 = clone $query;

    // Računanje vrednosti za određenu valutu
    $pending = $query->where('status', 0)
                     ->where('currency', $currency)
                     ->sum('debt');
    
    // Suma za price kada je status 1
    $priceSumStatus1 = $queryCopy1->where('status', 1)
                                  ->where('currency', $currency)
                                  ->sum('price');

    // Suma za price_part kada je status 0
    $pricePartSumStatus0 = $queryCopy2->where('status', 0)
                                      ->where('currency', $currency)
                                      ->sum('price_part');

    // Ukupna suma paid
    $paid = $priceSumStatus1 + $pricePartSumStatus0;

    return ['pending' => $pending, 'paid' => $paid];
}


    
}
