<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class WebsitesRequest extends FormRequest
{
    /**
     * Autorizacija se izvrsava preko 'middleware'-a. Zato je setovano 'true' 
     * kao povratna vrednost.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Validaciona pravila za akcije novi/izmeni kontrolera WebsitesController
     *
     * @return array
     */
    public function rules()
    {
        $imageRules = \App\Models\Image::getImageValidationRules();
        
        $website = $this->route('entity');
        
        return [
            'title'             => ['required', 'string', 'max:190',
                'unique:websites,title' . (isset($website->id) ? ',' . $website->id : '')
            ],
            'short_title'           => ['required', 'string', 'max:64',
                'unique:websites,short_title' . (isset($website->id) ? ',' . $website->id : ''),
            ],
            'url' => ['required', 'url', 'max:190',
                'unique:websites,url' . (isset($website->id) ? ',' . $website->id : ''),
            ],
            'image_logo'        => array_merge($imageRules, [Rule::dimensions()->minWidth(500)->minHeight(500)]),
            'image_icon'        => array_merge($imageRules, [Rule::dimensions()->minWidth(100)->minHeight(100)])
        ];
    }
}
