<?php

/*
|--------------------------------------------------------------------------
| Helper Funstions - Standard
|--------------------------------------------------------------------------
|   Helper functions may be added to this file if they solve a unique problem, 
|   and are used multiple times in the application codebase. 
|   The problem that they solve must be simple enough, so that it doesn't 
|   require assistance from other classes or traits.
|   This file is autoloaded via composer, under the files key.
|
|   Rules:
|       #1 if (!function_exists('method_name')) is a must
|       #2 documentation is a must
|       #3 no repeating functions are allowed, if a function solves a 
|           problem the same way & returns a value the same as another function 
|           it is considered a duplicate
|
*/

if (!function_exists('array_keys_exist')) {
    /**
     * Checks if all $keys exist in the $arr array
     * 
     * @param  array   $keys
     * @param  array   $arr
     * @return boolean
     * @author Alexander Dickson <alex@alexanderdickson.com>
     * @author Aleksa Cvijić     <aleksa.cvijic@cubes.rs>
     * @access public
     */
    function array_keys_exist(array $keys, array $arr) 
    {
        return !array_diff_key(array_flip($keys), $arr);
    }
}

if (!function_exists('str_cut')) {
    /**
     * @param  type    $text
     * @param  type    $limit
     * @return string
     * @author Aleksandar Stevanović <aleksandar.stevanovic@cubes.rs>
     * @author Aleksa Cvijić         <aleksa.cvijic@cubes.rs>
     * @access public
     */
    function str_cut($text, $limit, $delimiter = '...')
    {
        $cutedSeoDescription = mb_substr($text, 0, $limit);
        return (mb_strlen($text) > $limit) ? mb_substr($text, 0, mb_strrpos($cutedSeoDescription, ' ')) . $delimiter : $text;
    }
}

if (!function_exists('suffix_number_format')) {
    /**
     *  @param  int     $n
     *  @param  int     $precision [optional]
     *  @return type
     *  @access public
     *  @author Radley Sustaire <RadGH> <radleygh@gmail.com> <http://radleysustaire.com>
     *  @link   https://gist.github.com/RadGH/84edff0cc81e6326029c#file-short-number-format-php 
     */
    function suffix_number_format($n, $precision = 1) {
        if ($n < 900) {
            // 0 - 900
            $n_format = number_format($n, $precision);
            $suffix = '';
        } else if ($n < 900000) {
            // 0.9k-850k
            $n_format = number_format($n / 1000, $precision);
            $suffix = 'K';
        } else if ($n < 900000000) {
            // 0.9m-850m
            $n_format = number_format($n / 1000000, $precision);
            $suffix = 'M';
        } else if ($n < 900000000000) {
            // 0.9b-850b
            $n_format = number_format($n / 1000000000, $precision);
            $suffix = 'B';
        } else {
            // 0.9t+
            $n_format = number_format($n / 1000000000000, $precision);
            $suffix = 'T';
        }
      // Remove unecessary zeroes after decimal. "1.0" -> "1"; "1.00" -> "1"
      // Intentionally does not affect partials, eg "1.50" -> "1.50"
        if ( $precision > 0 ) {
            $dotzero = '.' . str_repeat( '0', $precision );
            $n_format = str_replace( $dotzero, '', $n_format );
        }
        return $n_format . $suffix;
    }
}

if (!function_exists('is_assoc')) {
    /* Testiraj da li je niz asocijativni ili 'obican' inkrementalni */
    function is_assoc(Array $arr) {
        if ([] === $arr) return NULL;
        return array_keys($arr) !== range(0, count($arr) - 1);
    }
}

/*
 * Check if all array members are numeric
 */
if ( ! function_exists('areNumeric') ) {
    /**
     * @param array $arr
     * @return boolean
     */
    function areNumeric()
    {
        $variadicArgs = func_get_args();
        
        foreach($variadicArgs as $a) {
            if(!is_numeric($a)) {
                return FALSE;
            }
        }
        return TRUE;
    }
    
} else {
    \Illuminate\Support\Facades\Log::debug('PROGRAMMING ERROR: "' . __FILE__ . 
            '" -> Helper function "areNumeric()" already declared!');
}

if ( ! function_exists('configMediaThumbs') ) {
    function configMediaThumbs()
    {
        return collect(config('media.thumbs'));
    }
}

if (!function_exists('cir2lat')) {
    function cir2lat($text, $default = false)
    {
        // 1 - cirilica - default
        // 2 - latinica
            $cyrillicCharacters = preg_split('/\s+/', 'а б в г д ђ е ж з и ј к л љ  м н њ  о п р с т ћ у ф х ц ч џ  ш А Б В Г Д Ђ Е Ж З И Ј К Л Љ  М Н Њ  О П Р С Т Ћ У Ф Х Ц Ч Џ  Ш');
            $latinTranslations  = preg_split('/\s+/', 'a b v g d đ e ž z i j k l lj m n nj o p r s t ć u f h c č dž š A B V G D Đ E Ž Z I J K L LJ M N NJ O P R S T Ć U F H C Č DŽ Š');

            $alternateTranslations1  = preg_split('/\s+/', 'đ ć š ž Đ Ž Ć Š');
            $text = (string) $text;
            $text = str_replace($cyrillicCharacters, $latinTranslations, $text);

        return $text;
    }
}