<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('truck_invoice_payments', function (Blueprint $table) {
            $table->id();
            $table->text('text')->nullable();
            $table->integer('company')->nullable();
            $table->decimal('price', 8, 2)->nullable()->default(0.00);
            $table->string('currency', 255)->nullable();
            $table->softDeletes();
            $table->timestamps();
            $table->unsignedBigInteger("created_by")->nullable();
            $table->unsignedBigInteger("updated_by")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('truck_invoice_payments');
    }
};
