(function () {
    CKEDITOR.plugins.add('medialibrary', {
        icons: 'medialibraryphotogallery,medialibraryphoto,medialibraryphotoupload', // %REMOVE_LINE_CORE%
        hidpi: true, // %REMOVE_LINE_CORE%
        requires: 'widget',
        init: function (editor) {
            var mediaLibrary = new MediaLibrary();
            
            editor.addCommand('MediaLibraryPhotoGallery', {
                exec: function (editor) {
                    var selectedElement = editor.getSelection().getStartElement();

                    if (selectedElement && selectedElement.hasAttribute('mlg_id')) {
                        galleryId = parseInt(selectedElement.getAttribute('mlg_id'));
                        
                        mediaLibrary.openPhotoGallery(function(galleryId, galleryName, galleryItems){
                            let galleryContainerHtml = `<p><img alt="${galleryName}" mlg_id="${galleryId}" src="/custom/ckeditor/plugins/medialibrary/icons/mlg.png" width="100%"></p>`;
                            editor.insertHtml(galleryContainerHtml);
                            mediaLibrary.modalHide();
                            
                        }, galleryId);
                        
                    }else{

                        mediaLibrary.openPhotoGallery(function(galleryId, galleryName, galleryItems){
                            let galleryContainerHtml = `<p><img alt="${galleryName}" mlg_id="${galleryId}" src="/custom/ckeditor/plugins/medialibrary/icons/mlg.png" width="100%"></p><p>&nbsp;</p>`;
                            editor.insertHtml(galleryContainerHtml);
                            mediaLibrary.modalHide();
                            
                        });
                    }

                    
                }
            });

            function libraryPhotoInit(editor, photoUpload = false) {
                var selectedElement = editor.getSelection().getStartElement();
                var figureContainer = null;
                let photoData = null;
                if(!photoUpload){
                    if (selectedElement && selectedElement.hasAttribute('m_id')) {
                    
                        var selectedElementParents = selectedElement.getParents();
                        
                        let photoId = parseInt(selectedElement.getAttribute('m_id')); 
    
                        for (var parentIndex in selectedElementParents) {
                            if(!selectedElementParents[parentIndex].is('figure')){
                                continue;
                            }
    
                            figureContainer = selectedElementParents[parentIndex];
                        }
                        
    
                        let figureContainerChildren = figureContainer.getChildren();
                        let position = 'center';
                        if(figureContainer.hasClass('pull-left')){
                            position = 'left';
                        }
                        if(figureContainer.hasClass('pull-right')){
                            position = 'right';
                        }
                        
                        // let dataSignature = figureContainerChildren.$[1].innerText;
                        let dataSignature = '';
                        if(figureContainerChildren.$[2] != undefined){
                            dataSignature = figureContainerChildren.$[2].innerText;
                            photoData = {
                                'signature': dataSignature
                            } 
                        }
                        photoData = {
                            'photoId': photoId,
                            'thumbSizeId': selectedElement.getAttribute('m_ext'),
                            'position': position
                        } 
       
                    }
    
                    if(photoData){
                        mediaLibrary.openSelectPhoto(function(photoObj, thumbSizeId, position, signature){
                            figureContainer.remove();
                            console.log('hej',signature);
                            let licence_name = '';
                            if(photoObj.photoLicenceName){
                                licence_name = photoObj.photoLicenceName+' / ';
                            }
                            let photoContainerHtml = `<figure class="single-news-img${createImgPosClass(position)}"><img m_ext="${thumbSizeId}" m_id="${photoObj.photoId}" src="${photoObj.photoAllImgSources[thumbSizeId]}" alt="${licence_name}${photoObj.photoSource}"><div class="image-info"><span class="source">${licence_name}${photoObj.photoSource} </span><span class="caption">${signature}</span></div></figure>`;
                                editor.insertHtml(photoContainerHtml);
                                mediaLibrary.modalHide();
                        }, photoData);
                    }else{
                        mediaLibrary.openSelectPhoto(function(photoObj, thumbSizeId, position, signature){
                            let licence_name = '';
                            if(photoObj.photoLicenceName){
                                licence_name = photoObj.photoLicenceName+' / ';
                            }
                            let photoContainerHtml = `<figure class="single-news-img${createImgPosClass(position)}"><img m_ext="${thumbSizeId}" m_id="${photoObj.photoId}" src="${photoObj.photoAllImgSources[thumbSizeId]}" alt="${licence_name}${photoObj.photoSource}"><div class="image-info"><span class="source">${licence_name}${photoObj.photoSource} </span><span class="caption">${signature}</span></div></figure>`;
                            editor.insertHtml(photoContainerHtml);
                            mediaLibrary.modalHide();
                        }); 
                    } 
                }else{
                    
                    let config = {
                        'categoryId': 1,
                    }

                    mediaLibrary.openUploadPhotos(config); 
                    mediaLibrary.setInsertCallback(function(photoObj, thumbId, position, signature) {
                        let licence_name = '';
                            if(photoObj.photoLicenceName){
                                licence_name = photoObj.photoLicenceName+' / ';
                            }
                        let photoContainerHtml = `<figure class="single-news-img${createImgPosClass(position)}"><img m_ext="${thumbId}" m_id="${photoObj.photoId}" src="${photoObj.photoAllImgSources[thumbId]}" alt="${licence_name}${photoObj.photoSource}"><div class="image-info"><span class="source">${licence_name}${photoObj.photoSource} </span><span class="caption">${signature}</span></div></figure>`;
                        editor.insertHtml(photoContainerHtml);
                        mediaLibrary.modalHide();
                    });
                }
            };

            function createImgPosClass(position){
                let positionClass;
                if(position == 'center'){
                    positionClass = '';
                }else{
                    positionClass = ' pull-' + position;
                }

                return positionClass;
            }

            editor.addCommand('MediaLibraryPhoto', {
                exec: function (editor) {
                    libraryPhotoInit(editor);
                }
            });

            editor.addCommand('MediaLibraryPhotoUpload', {
                exec: function (editor) {
                    libraryPhotoInit(editor, true);

                }
            });

            editor.addCommand('MediaLibraryPhotoSetAsLeading', {
                exec: function (editor) {
                    let photoId = parseInt(editor.getSelection().getStartElement().getAttribute('m_id'));
                    
                    mediaLibrary.getPhoto(photoId, function(photoObj){
                        insertAllImages(photoObj);
                    });
                    
                }
            });

            editor.ui.addButton('MediaLibraryPhoto', {
                label: 'Fotografija',
                command: 'MediaLibraryPhoto',
                icon: 'medialibraryphoto',
                toolbar: 'medialibrary'
            });

            editor.ui.addButton('MediaLibraryPhotoUpload', {
                label: 'Fotografija Upload',
                command: 'MediaLibraryPhotoUpload',
                icon: 'medialibraryphotoupload',
                toolbar: 'medialibrary'
            });

            editor.ui.addButton('MediaLibraryPhotoGallery', {
                label: 'Foto Galerija',
                command: 'MediaLibraryPhotoGallery',
                icon: 'medialibraryphotogallery',
                toolbar: 'medialibrary'
            });

            editor.on('doubleclick', function (evt) {
                var element = evt.data.element;

                if (element && element.is('img')) {
                    if (element.hasAttribute('m_id')) {
                        evt.cancel();
                        editor.execCommand('MediaLibraryPhoto');
                    } else if (element.hasAttribute('mlg_id')) {
                        evt.cancel();
                        editor.execCommand('MediaLibraryPhotoGallery');
                    } 
                }
            });

            if (editor.contextMenu) {
                editor.addMenuGroup('medialibrary');

                editor.contextMenu.addListener(function (element, selection) {
                    if (element.hasAttribute('m_id')) {

                        editor.contextMenu.removeAll();
                        editor.addMenuItems({
                            MediaLibraryPhotoEdit: {
                                label: 'Izmeni Fotografiju',
                                icon: 'medialibraryphoto',
                                command: 'MediaLibraryPhoto',
                                group: 'medialibrary',
                                order: 1
                            },
                            MediaLibraryPhotoEditSetAsLeading: {
                                label: 'Postavi fotografiju kao vode\u0107u',
                                icon: 'medialibraryphoto',
                                command: 'MediaLibraryPhotoSetAsLeading',
                                group: 'medialibrary',
                                order: 2
                            },
							DeleteLatestDiv: {
        	                    label : 'Obriši okvir',
        	                    command : 'deleteLatestDiv',
        	                    group : 'news',
        	                    order : 3
        					}
                        });

                        return {
                            MediaLibraryPhotoEdit: CKEDITOR.TRISTATE_ON,
                            MediaLibraryPhotoEditSetAsLeading: CKEDITOR.TRISTATE_ON,
							DeleteLatestDiv: CKEDITOR.TRISTATE_ON
                        };

                    } else if (element.hasAttribute('mlg_id')) {
                        editor.contextMenu.removeAll();
                        editor.addMenuItems({
                            MediaLibraryPhotoGalleryEdit: {
                                label: 'Izmeni Foto Galeriju',
                                icon: 'medialibraryphotogallery',
                                command: 'MediaLibraryPhotoGallery',
                                group: 'medialibrary',
                                order: 1
                            },
                            DeleteLatestDiv: {
        	                    label : 'Obriši okvir',
        	                    command : 'deleteLatestDiv',
        	                    group : 'news',
        	                    order : 2
        					}

                        });

                        return {
                            MediaLibraryPhotoGalleryEdit: CKEDITOR.TRISTATE_ON,
                            DeleteLatestDiv: CKEDITOR.TRISTATE_ON
                        };
                    } else if (selection.getType() == CKEDITOR.SELECTION_NONE || selection.getType() == CKEDITOR.SELECTION_TEXT) {
                        editor.addMenuItems({
                            MediaLibraryPhoto: {
                                label: 'Ubaci Fotografiju',
                                icon: 'medialibraryphoto',
                                command: 'MediaLibraryPhoto',
                                group: 'medialibrary',
                                order: 91
                            },
                            MediaLibraryPhotoUpload: {
                                label: 'Uploaduj i Ubaci Fotografiju',
                                icon: 'medialibraryphotoupload',
                                command: 'MediaLibraryPhotoUpload',
                                group: 'medialibrary',
                                order: 92
                            },
                            MediaLibraryPhotoGallery: {
                                label: 'Ubaci Foto Galeriju',
                                icon: 'medialibraryphotogallery',
                                command: 'MediaLibraryPhotoGallery',
                                group: 'medialibrary',
                                order: 93
                            }
                        });

                        return {
                            MediaLibraryPhoto: CKEDITOR.TRISTATE_OFF,
                            MediaLibraryPhotoGallery: CKEDITOR.TRISTATE_OFF,
                        };
                    }
                });
            }
        }
    });
})();

            