// /*
// * Embed Media Dialog based on http://www.fluidbyte.net/embed-youtube-vimeo-etc-into-ckeditor
// *
// * Plugin name:      mediaembed
// * Menu button name: MediaEmbed
// *
// * Youtube Editor Icon
// * http://paulrobertlloyd.com/
// *
// * @author Fabian Vogelsteller [frozeman.de]
// * @version 0.5
// */
// ( function() {
CKEDITOR.plugins.add('polls', {
    icons: 'poll', // %REMOVE_LINE_CORE%
    hidpi: true, // %REMOVE_LINE_CORE%
    init: function (editor) {
        var poll = this;
        var pollsModal = getPollsModal();
        editor.addCommand('Polls', {
            exec: function (editor) {
                let selectedElement = editor.getSelection().getStartElement();
                let entityId = null;
                
                $('#pollsModal #show-form').on('click', function (e) {
                    pollsModal.setProperty('form_task', 'create');
                });
                $('#pollsModal [name="polls-intexts"]').on('change', function (e) {

                    entityId = $(this).val();
                    pollsModal.getOneEntity({
                        'entityId': entityId
                    }).setProperty('form_task', 'update');
                    $('#polls-form').attr('style', 'display:show;');
                })
                /* In  CKEDITOR check if edit element */
                if (selectedElement && selectedElement.hasAttribute('poll_id')) {
                    entityId = selectedElement.getAttribute('poll_id');

                    $('#polls-form').attr('style', 'display:show;');
                    $('#select-polls').attr('style', 'display:show;');
                }
                pollsModal.openModal(entityId,function (poll) {
                    let pollContainerHtml = `<p><img alt="" poll_id="${poll.entityId}" src="/custom/ckeditor/plugins/polls/poll_image.png" style="display: block; width: 100%;"/></p>`;
                    editor.insertHtml(pollContainerHtml);
                    editor.focus();
                });
            }
        });

        editor.ui.addButton('Polls', {
            label: 'Anketa',
            command: 'Polls',
            icon: 'poll',
            toolbar: 'polls'
        });

        editor.on('doubleclick', function (evt) {
            var element = evt.data.element;

            if (element && element.is('img')) {
                if (element.hasAttribute('poll_id')) {
                    evt.cancel();
                    editor.execCommand('Polls');
                }
            }
        });

        if (editor.contextMenu) {
            editor.addMenuGroup('polls');

            editor.contextMenu.addListener(function (element, selection) {
                if (element.hasAttribute('poll_id')) {
                    editor.contextMenu.removeAll();
                    editor.addMenuItems({
                        PollsEdit: {
                            label: 'Izmeni Anketu',
                            icon: 'poll',
                            command: 'Polls',
                            group: 'polls',
                            order: 1
                        },
                        DeleteLatestDiv: {
                            label : 'Obriši okvir',
                            command : 'deleteLatestDiv',
                            group : 'news',
                            order : 2
                        }
                    });

                    return {
                        PollsEdit: CKEDITOR.TRISTATE_ON,
                        DeleteLatestDiv: CKEDITOR.TRISTATE_ON
                    };
                } else if (selection.getType() == CKEDITOR.SELECTION_NONE || selection.getType() == CKEDITOR.SELECTION_TEXT) {
                    editor.addMenuItems({
                        Polls: {
                            label: 'Ubaci Anketu',
                            icon: 'poll',
                            command: 'Polls',
                            group: 'polls',
                            order: 94
                        }
                    });

                    return {
                        Polls: CKEDITOR.TRISTATE_OFF
                    };
                }
            });
        }
    }
});
// })();
