<!-- begin:system-message rendering script-->
<script type="text/javascript">
    function showSystemMessage(text, type) {
        type = type ? type : 'success';

        var options = {
            text: text,
            position: 'top-right',
            icon: type
        };

        switch (type) {
            case 'success':
                $.extend(options, {
                    heading: '@lang("OK")',
                    loaderBg: '#5ba035',
                    hideAfter: 1500
                });
                break;
            case 'info':
                $.extend(options, {
                    heading: '@lang("Info")',
                    loaderBg: '#3b98b5',
                    hideAfter: 2000
                });
                break;
            case 'warning':
                $.extend(options, {
                    heading: '@lang("Upozorenje")',
                    loaderBg: '#da8609',
                    hideAfter: 3000
                });
                break;
            case 'error':
                $.extend(options, {
                    heading: '@lang("Greška")',
                    loaderBg: '#bf441d',
                    hideAfter: 15000
                });
                break;
            default:
                $.extend(options, {
                    heading: '@lang("Obaveštenje")',
                    loaderBg: '#1ea69a',
                    hideAfter: 1500
                });
                break;
        }


        $.toast(options);
    }
    
    @unless(empty($message = request()->getSystemMessage()))
        showSystemMessage("{!! addslashes($message['text']) !!}", "{{ $message['type'] }}");
    @endunless
</script>
<!-- end:system-message rendering script-->
