@extends('_layout.layout')

@section('head_title', __('Finansije'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Dnevni pregled"),
])

<style>
 .card {
    width: 100%; /* Obezbeđuje da kartica zauzima punu širinu */
}

.table-responsive {
    width: 100%; /* Obezbeđuje da tabela zauzima punu širinu roditelja */
}

.table {
    width: 100%; /* Obezbeđuje da tabela zauzima punu širinu */
}
</style>

<div class="row">

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-purple">
            <div class="card-body">
                <i class="mdi mdi-chart-line widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Statistics">Ukupan broj izlaznih faktura</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$invoicesTotal}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0"><b></b>2025. godina</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-info">
            <div class="card-body">
                <i class="mdi mdi-calendar-today widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 text-overflow" title="User Today">{{now()->format('F')}}</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$invoicesThisMonth}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Izlazne fakture</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-purple">
            <div class="card-body">
                <i class="mdi mdi-chart-line widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Statistics">Ukupan broj ulaznih faktura</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$procurementTotal}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0"><b></b>2025. godina</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-info">
            <div class="card-body">
                <i class="mdi mdi-calendar-today widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 text-overflow" title="User Today">{{now()->format('F')}}</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$procurementThisMonth}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Ulazne fakture</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

</div>

<div class="row">

    {{-- <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-purple">
            <div class="card-body">
                <i class="mdi mdi-access-point-network widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Statistics">Ukupan broj faktura</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$invoicesTotal}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0"><b>U valuti KM za ovu godinu</b></p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-info">
            <div class="card-body">
                <i class="mdi mdi-access-point-network widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 font-secondary text-overflow" title="User Today">{{$currentMonth = now()->format('F');}}</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$invoicesThisMonth}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Ukupan broj faktura za ovaj mjesec</p>
                </div>
            </div>
        </div>
    </div><!-- end col --> --}}
    

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-pink">
            <div class="card-body">
                <i class="mdi mdi-timetable widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Request Per Minute">Fakture koje nisu placene</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$invoicesStatus0}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Izlazne 2025</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-success">
            <div class="card-body">
                <i class="mdi mdi-check-circle widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 font-secondary text-overflow" title="New Downloads">Fature koje su placene</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$invoicesStatus1}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Izlazne 2025</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-pink">
            <div class="card-body">
                <i class="mdi mdi-timetable widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Request Per Minute">Fakture koje nisu placene</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$procurementStatus0}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Ulazne 2025</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-success">
            <div class="card-body">
                <i class="mdi mdi-check-circle widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 font-secondary text-overflow" title="New Downloads">Fature koje su placene</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$procurementStatus1}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Ulazne 2025</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

</div>



<div class="row">
    <div class="col-6">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Izlazne fakture')</h3>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12 d-flex justify-content-center">
                        <button class="btn btn-secondary" id="prev-date">&#8592;</button> <!-- Strelica nazad -->
                        <div class="mx-2">
                            <input
                                type="text"
                                class="form-control text-center"
                                name="date_start"
                                id="date_start"
                                value=""
                            >
                        </div>
                        <button class="btn btn-secondary" id="next-date">&#8594;</button> <!-- Strelica napred -->
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class="">@lang('ID')</th>
                                <th class="">@lang('Firma')</th>
                                <th class="">@lang('Iznos')</th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-6">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Ulazne fakture')</h3>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12 d-flex justify-content-center">
                        <button class="btn btn-secondary" id="prev-date1">&#8592;</button> <!-- Strelica nazad -->
                        <div class="mx-2">
                            <input
                                type="text"
                                class="form-control text-center"
                                name="date_start1"
                                id="date_start1"
                                value=""
                            >
                        </div>
                        <button class="btn btn-secondary" id="next-date1">&#8594;</button> <!-- Strelica napred -->
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table1" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class="">@lang('ID')</th>
                                <th class="">@lang('Firma')</th>
                                <th class="">@lang('Iznos')</th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-6">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Kamioni - Obaveze ( ' . \Carbon\Carbon::now()->locale('sr')->isoFormat('MMMM') . ' mjesec )')</h3>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                </div>
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table1" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class="">@lang('Kamion')</th>
                                <th class="">@lang('Tablice')</th>
                                <th class="">@lang('Registracija')</th>
                                <th class="">@lang('Sestomjesecni')</th>
                                <th class="">@lang('PP Aparat')</th>
                                <th class="">@lang('Tahograf')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($trucks as $truck)
                            <tr>
                                <td>{{ $truck->name }}</td>
                                <td>{{ $truck->number_of_plates }}</td>
                                
                                <td>
                                    {{-- Prikazuje samo ako je datum registracije u trenutnom mesecu --}}
                                    {{ \Carbon\Carbon::parse($truck->registracija_end)->isCurrentMonth() ? $truck->registracija_end : '' }}
                                </td>
                                
                                <td>
                                    {{-- Prikazuje samo ako je datum šestomesečnog pregleda u trenutnom mesecu --}}
                                    {{ \Carbon\Carbon::parse($truck->sestomjesecni_end)->isCurrentMonth() ? $truck->sestomjesecni_end : '' }}
                                </td>
                                
                                <td>
                                    {{-- Prikazuje samo ako je datum za PP aparat u trenutnom mesecu --}}
                                    {{ \Carbon\Carbon::parse($truck->pp_end)->isCurrentMonth() ? $truck->pp_end : '' }}
                                </td>
                                
                                <td>
                                    {{-- Prikazuje samo ako je datum za tahograf u trenutnom mesecu --}}
                                    {{ \Carbon\Carbon::parse($truck->tahograf_end)->isCurrentMonth() ? $truck->tahograf_end : '' }}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
</div>




{{-- <div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title m-t-0">Bar Chart</h4>
                <p class="text-muted m-b-30 text-overflow">
                    A bar chart is a way of showing data as bars. It is sometimes used to
                    show trend data, and the comparison of multiple data sets side by side.
                </p>

                <canvas id="bar" height="300"></canvas>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="accordion" id="accordion-test">
            <div class="card mb-2">
                <div class="card-heading bg-primary">
                    <h4 class="card-title font-14">
                        <a href="#" class="collapsed text-white" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Collapsible Group Item #1
                        </a>
                    </h4>
                </div>
                <div id="collapseOne" class="collapse" data-parent="#accordion-test">
                    <div class="card-body">
                        <p class="mb-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS.</p>
                    </div>
                </div>
            </div>
            <div class="card mb-2">
                <div class="card-heading bg-info">
                    <h4 class="card-title font-14">
                        <a href="#" class="text-white" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Collapsible Group Item #2
                        </a>
                    </h4>
                </div>
                <div id="collapseTwo" class="collapse show" data-parent="#accordion-test">
                    <div class="card-body">
                        <p class="mb-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS.</p>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-heading bg-custom">
                    <h4 class="card-title font-14">
                        <a href="#" class="collapsed text-white" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Collapsible Group Item #3
                        </a>
                    </h4>
                </div>
                <div id="collapseThree" class="collapse" data-parent="#accordion-test">
                    <div class="card-body">
                        <p class="mb-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven't heard of them accusamus labore sustainable VHS.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> --}}

<hr>
<div class="row">

    {{-- <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-purple">
            <div class="card-body">
                <i class="mdi mdi-access-point-network widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Statistics">Ukupan broj faktura</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$invoicesTotal}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0"><b>U valuti KM za ovu godinu</b></p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-info">
            <div class="card-body">
                <i class="mdi mdi-access-point-network widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 font-secondary text-overflow" title="User Today">{{$currentMonth = now()->format('F');}}</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$invoicesThisMonth}}</span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Ukupan broj faktura za ovaj mjesec</p>
                </div>
            </div>
        </div>
    </div><!-- end col --> --}}
    

    <div class="col-xl-2 col-md-6">
        
    </div><!-- end col -->

    <div class="col-xl-4 col-md-6">
        <div class="card widget-box-two widget-two-success">
            <div class="card-body">
                <i class="mdi mdi-cash widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 font-secondary text-overflow" title="New Downloads">Ukupna zarada u 2025. godini</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$zarada}} KM</span> <small></i></small></h2>
                    <p class="text-white m-0">Samo placene fakture</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-4 col-md-6">
        <div class="card widget-box-two widget-two-pink">
            <div class="card-body">
                <i class="mdi mdi-cash widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Request Per Minute">Ukupni troskovi u 2025. godini</p>
                    <h2 class="text-white"><span data-plugin="counterup">{{$potrosnja}} KM</span> <small></small></h2>
                    <p class="text-white m-0">Samo placene fakture</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-2 col-md-6">
        
    </div><!-- end col -->

</div>
{{-- <div class="row">
    <div class="col-xl-4">
        <div class="card">
            <div class="card-body">
                <h4 class="text-dark  header-title m-t-0 m-b-30">Vozac 1</h4>

                <div class="widget-chart text-center">
                    <input data-plugin="knob" data-width="150" data-height="150" data-linecap=round data-fgColor="#5d9cec" value="55" data-skin="tron" data-angleOffset="180" data-readOnly=true data-thickness=".15"/>

                    <p class="text-muted m-t-30">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer nec odio. Praesent libero. Nunc nec dui vitae urna cursus lacinia. In venenatis eget justo in dictum. Vestibulum auctor raesent quisnm.</p>

                    <div class="row text-center m-t-30">
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">1,507</h3>
                            <p class="text-muted">Total Sales</p>
                        </div>
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">916</h3>
                            <p class="text-muted">Open Compaign</p>
                        </div>
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">22</h3>
                            <p class="text-muted">Daily Sales</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="col-xl-4">
        <div class="card">
            <div class="card-body">
                <h4 class="text-dark  header-title m-t-0 m-b-30">Vozac 2</h4>

                <div class="widget-chart text-center">
                    <input data-plugin="knob" data-width="150" data-height="150" data-linecap=round data-fgColor="#fb6d9d" value="80" data-skin="tron" data-angleOffset="180" data-readOnly=true data-thickness=".15"/>

                    <p class="text-muted m-t-30">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer nec odio. Praesent libero. Nunc nec dui vitae urna cursus lacinia. In venenatis eget justo in dictum. Vestibulum auctor raesent quisnm.</p>

                    <div class="row text-center m-t-30">
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">1,507</h3>
                            <p class="text-muted">Total Sales</p>
                        </div>
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">916</h3>
                            <p class="text-muted">Open Compaign</p>
                        </div>
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">22</h3>
                            <p class="text-muted">Daily Sales</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="col-xl-4">
        <div class="card">
            <div class="card-body">
                <h4 class="text-dark header-title m-t-0 m-b-30">Vozac 3</h4>

                <div class="widget-chart text-center">
                    <input data-plugin="knob" data-width="150" data-height="150" data-linecap=round data-fgColor="#34d3eb" value="60" data-skin="tron" data-angleOffset="180" data-readOnly=true data-thickness=".15"/>

                    <p class="text-muted m-t-30">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer nec odio. Praesent libero. Nunc nec dui vitae urna cursus lacinia. In venenatis eget justo in dictum. Vestibulum auctor raesent quisnm.</p>

                    <div class="row text-center m-t-30">
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">1,507</h3>
                            <p class="text-muted">Total Sales</p>
                        </div>
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">916</h3>
                            <p class="text-muted">Open Compaign</p>
                        </div>
                        <div class="col-4">
                            <h3 data-plugin="counterup" class="text-muted">22</h3>
                            <p class="text-muted">Daily Sales</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div> --}}

@endsection

@push('footer_scripts')
<script>
$(document).ready(function() {
    $("[data-plugin='knob']").knob();
});
</script>

<script src="{{asset('/theme/plugins/jquery-knob/jquery.knob.js')}}"></script>
<script src="{{asset('/theme/plugins/waypoints/jquery.waypoints.min.js')}}"></script>
<script src="{{asset('/theme/plugins/counterup/jquery.counterup.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/theme/plugins/jquery-knob/excanvas.js')}}"></script>

<script>
// Postavi današnji datum
const dateInput = document.getElementById('date_start');
const dateInput1 = document.getElementById('date_start1');
const today = new Date();
dateInput.value = formatDate(today);
dateInput1.value = formatDate(today);

var blade = {
        datatablesAjaxUrl1: "@route('truck.finance_datatable')",
        datatablesAjaxUrl2: "@route('truck.finance_datatable1')",
    };

// Funkcija za formatiranje datuma u DD-MM-YYYY
function formatDate(date) {
    const day = ("0" + date.getDate()).slice(-2);
    const month = ("0" + (date.getMonth() + 1)).slice(-2);
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
}

// Strelica napred - povećava datum za jedan dan
document.getElementById('next-date').addEventListener('click', function() {
    const currentDate = new Date(dateInput.value.split('-').reverse().join('-'));
    currentDate.setDate(currentDate.getDate() + 1);
    dateInput.value = formatDate(currentDate);
    table.ajax.reload(); // Osvježi tablicu nakon promjene datuma
});

// Strelica nazad - smanjuje datum za jedan dan
document.getElementById('prev-date').addEventListener('click', function() {
    const currentDate = new Date(dateInput.value.split('-').reverse().join('-'));
    currentDate.setDate(currentDate.getDate() - 1);
    dateInput.value = formatDate(currentDate);
    table.ajax.reload(); // Osvježi tablicu nakon promjene datuma
});

// Strelica napred - povećava datum za jedan dan
document.getElementById('next-date1').addEventListener('click', function() {
    const currentDate = new Date(dateInput1.value.split('-').reverse().join('-'));
    currentDate.setDate(currentDate.getDate() + 1);
    dateInput1.value = formatDate(currentDate);
    table1.ajax.reload(); // Osvježi tablicu nakon promjene datuma
});

// Strelica nazad - smanjuje datum za jedan dan
document.getElementById('prev-date1').addEventListener('click', function() {
    const currentDate = new Date(dateInput1.value.split('-').reverse().join('-'));
    currentDate.setDate(currentDate.getDate() - 1);
    dateInput1.value = formatDate(currentDate);
    table1.ajax.reload(); // Osvježi tablicu nakon promjene datuma
});

// Postavi DataTables
var table = $('#entity-list-table').DataTable({
    "autoWidth": true,
    "processing": true,
    "serverSide": true,
    "paging": false, // Onemogućava paginaciju
    "info": false, // Onemogućava informacije o prikazu
    "language": {
            emptyTable: "Nije pronađena ni jedna faktura za današnji datum"
        },
    "searching": false,
    "ajax": {
        url: blade.datatablesAjaxUrl1,
        type: "post",
        data: function(d) {
            d.date_start = $('#date_start').val(); // Pošalji trenutni datum
        }
    },
    "columns": [
        {"data": "id_invoice", orderable: false, "className": ""},
        {"data": "company", orderable: false, "className": ""},
        {"data": "price", orderable: false, "className": ""},
    ],
    "order": [[0, "asc"]],
});

var table1 = $('#entity-list-table1').DataTable({
    "autoWidth": true,
    "processing": true,
    "serverSide": true,
    "paging": false, // Onemogućava paginaciju
    "info": false, // Onemogućava informacije o prikazu
    "language": {
            emptyTable: "Nije pronađena ni jedna faktura za današnji datum"
        },
    "searching": false,
    "ajax": {
        url: blade.datatablesAjaxUrl2,
        type: "post",
        data: function(d) {
            d.date_start1 = $('#date_start1').val(); // Pošalji trenutni datum
        }
    },
    "columns": [
        {"data": "id_invoice", orderable: false, "className": ""},
        {"data": "company", orderable: false, "className": ""},
        {"data": "price", orderable: false, "className": ""},
    ],
    "order": [[0, "asc"]],
});

</script>

@endpush