@extends('_layout.layout')

@section('head_title', __('Ulazne Fakture') . ' - ' . __('Fakture'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Ulazne Fakture"),
    'breadcrumbs' => [
        route('truck.procurement') => __('Ulazne Fakture')
    ]
])
<style>
    #entity-list-table thead th:first-child.sorting::after,
    #entity-list-table thead th:first-child.sorting_asc::after,
    #entity-list-table thead th:first-child.sorting_desc::after {
        display: none;
    }

    #entity-list-table th:nth-child(3),
    #entity-list-table td:nth-child(3) {
        max-width: 350px; 
        overflow: hidden;
        text-overflow: ellipsis; 
        white-space: nowrap; 
    }

    .dataTables_filter {
        display: none;
    }

    .date-highlight {
        padding: 5px;
        border-radius: 5px;
        display: inline-block;
    }
    .date-red {
        background-color: red;
        color: white;
    }
    .date-yellow {
        background-color: yellow;
        color: black;
    }
    .date-green {
        background-color: green;
        color: white;
    }
    .summary-box {
        padding: 20px;
        border-radius: 10px;
        color: black;
        text-align: center;
        font-size: 20px;
    }

    .summary-box {
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        background: #f8f9fa;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    
    .summary-eur {
        background-color: white;
    }
    .summary-km {
        background-color: white;
    }
    .summary-rsd {
        background-color: white;
    }
</style>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Izvestaj sa filterima')</h3>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-2">
                        <label for="date_start">@lang('Datum od')</label>
                        <input
                                type="text"
                                class="form-control"
                                name="date_start"
                                id="date_start"
                                value=""
                            >
                    </div>
                    <div class="col-md-2">
                        <label for="date_end">@lang('Datum do')</label>
                        <input
                                type="text"
                                class="form-control"
                                name="date_end"
                                id="date_end"
                                value=""
                            >
                    </div>
                    <div class="col-md-2">
                        <label for="status">@lang('Filter po statusu:')</label>
                        <select id="status" class="form-control">
                            <option value="">@lang('Svi')</option>
                            <option value="1">@lang('Plaćeno')</option>
                            <option value="0">@lang('Neplaćeno')</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="company">@lang('Izaberi firmu')</label>
                        <select id="company" class="form-control">
                            <option value="">@lang('Sve firme')</option>
                            @foreach ($companies as $company)
                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class="">@lang('Broj fakture')</th>
                                <th class="">@lang('Firma')</th>
                                <th class="">@lang('Opis')</th>
                                <th class="">@lang('Datum kreiranja')</th>
                                <th class="">@lang('Rok placanja')</th>
                                <th class="">@lang('Iznos')</th>
                                <th class="disabled-sorting text-right">@lang('Opcije')</th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="summary-box summary-km">
            <div>Fakture u valuti KM</div>
            <div class="text-danger">@lang('Ceka na uplatu'): <span id="paid-km">0</span> KM</div>
            <div class="text-success">@lang('Ukupno uplaceno'): <span id="pending-km">0</span> KM</div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="summary-box summary-eur">
            <div>Fakture u valuti EUR</div>
            <div class="text-danger">@lang('Ceka na uplatu'): <span id="pending-eur">0</span> EUR</div>
            <div class="text-success">@lang('Ukupno uplaceno'): <span id="paid-eur">0</span> EUR</div>
        </div>
    </div>
</div>

@endsection

@push('footer_scripts')
<script>
$(function() {

    var dateFormat = 'dd/mm/yyyy';

    $('#date_start').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    $('#date_end').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true
        });

    var blade = {
        datatablesAjaxUrl: "@route('truck.reports_procurement_datatable')",
    };

    // DATATABLES
    var table = $('#entity-list-table').DataTable({
        "autoWidth": true,
        "processing": true,
        "serverSide": true,
        "searchable": false,
        "ajax": {
            url: blade.datatablesAjaxUrl,
            type: "post",
            data: function(d) {
                d.date_start = $('#date_start').val();
                d.date_end = $('#date_end').val();
                d.driver = $('#driver').val();
                d.company = $('#company').val();
                d.status = $('#status').val();
            }
        },
        "columns": [
            {"data": "id_invoice", orderable: false, "className": ""},
            {"data": "company", orderable: false, "className": ""},
            {"data": "text", orderable: false, "className": ""},
            {"data": "date_start", orderable: false, searchable: false, "className": ""},
            {"data": "date_end", orderable: false, searchable: false, "className": ""},
            {"data": "price", orderable: false, "className": ""},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
        "order": [[0, "asc"]],
        "rowCallback": function(row, data, index) {
            var today = moment();
            var dateEnd = moment(data.date_end, 'DD-MM-YYYY'); // Adjust the date format to match your data

            // Reset any previous highlighting
            $('td:eq(4)', row).removeClass('date-red date-yellow date-green');

            // Add the appropriate class based on the date condition
            if (data.status == 1) {
                $('td:eq(4)', row).html('<span class="date-highlight date-green">' + data.date_end + '</span>');
            } else if (today.isSameOrAfter(dateEnd, 'day')) {
                $('td:eq(4)', row).html('<span class="date-highlight date-red">' + data.date_end + '</span>');
            } else if (today.isSameOrAfter(dateEnd.subtract(7, 'days'), 'day')) {
                $('td:eq(4)', row).html('<span class="date-highlight date-yellow">' + data.date_end + '</span>');
            } else {
                $('td:eq(4)', row).html(data.date_end);
            }
        },
        "drawCallback": function(settings) {
            var api = this.api();
            var sums = settings.json;

            // Calculate and display total sums
            var pendingKm = parseFloat(sums.sumKM.pending);
            var paidKm = parseFloat(sums.sumKM.paid);
            var pendingEur = parseFloat(sums.sumEUR.pending);
            var paidEur = parseFloat(sums.sumEUR.paid);

            // Update values in the summary boxes
            $('#paid-km').text(pendingKm.toFixed(2));
            $('#pending-km').text(paidKm.toFixed(2));
            $('#pending-eur').text(pendingEur.toFixed(2));
            $('#paid-eur').text(paidEur.toFixed(2));
        }
    });

    $('#date_start, #date_end, #driver, #company, #status').change(function() {
        table.ajax.reload();
    });

});
</script>
@endpush
