<?php $__env->startSection('head_title', __('Finansije')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Dnevni pregled"),
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
 .card {
    width: 100%; /* Obezbeđuje da kartica zauzima punu širinu */
}

.table-responsive {
    width: 100%; /* Obezbeđuje da tabela zauzima punu širinu roditelja */
}

.table {
    width: 100%; /* Obezbeđuje da tabela zauzima punu širinu */
}
</style>

<div class="row">

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-purple">
            <div class="card-body">
                <i class="mdi mdi-chart-line widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Statistics">Ukupan broj izlaznih faktura</p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($invoicesTotal); ?></span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0"><b></b>2025. godina</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-info">
            <div class="card-body">
                <i class="mdi mdi-calendar-today widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 text-overflow" title="User Today"><?php echo e(now()->format('F')); ?></p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($invoicesThisMonth); ?></span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Izlazne fakture</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-purple">
            <div class="card-body">
                <i class="mdi mdi-chart-line widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Statistics">Ukupan broj ulaznih faktura</p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($procurementTotal); ?></span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0"><b></b>2025. godina</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-info">
            <div class="card-body">
                <i class="mdi mdi-calendar-today widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 text-overflow" title="User Today"><?php echo e(now()->format('F')); ?></p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($procurementThisMonth); ?></span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Ulazne fakture</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

</div>

<div class="row">

    
    

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-pink">
            <div class="card-body">
                <i class="mdi mdi-timetable widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Request Per Minute">Fakture koje nisu placene</p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($invoicesStatus0); ?></span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Izlazne 2025</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-success">
            <div class="card-body">
                <i class="mdi mdi-check-circle widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 font-secondary text-overflow" title="New Downloads">Fature koje su placene</p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($invoicesStatus1); ?></span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Izlazne 2025</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-pink">
            <div class="card-body">
                <i class="mdi mdi-timetable widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Request Per Minute">Fakture koje nisu placene</p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($procurementStatus0); ?></span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Ulazne 2025</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-3 col-md-6">
        <div class="card widget-box-two widget-two-success">
            <div class="card-body">
                <i class="mdi mdi-check-circle widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 font-secondary text-overflow" title="New Downloads">Fature koje su placene</p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($procurementStatus1); ?></span> <small><i class="mdi mdi-arrow-up text-white"></i></small></h2>
                    <p class="text-white m-0">Ulazne 2025</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

</div>



<div class="row">
    <div class="col-6">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Izlazne fakture'); ?></h3>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12 d-flex justify-content-center">
                        <button class="btn btn-secondary" id="prev-date">&#8592;</button> <!-- Strelica nazad -->
                        <div class="mx-2">
                            <input
                                type="text"
                                class="form-control text-center"
                                name="date_start"
                                id="date_start"
                                value=""
                            >
                        </div>
                        <button class="btn btn-secondary" id="next-date">&#8594;</button> <!-- Strelica napred -->
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class=""><?php echo app('translator')->get('ID'); ?></th>
                                <th class=""><?php echo app('translator')->get('Firma'); ?></th>
                                <th class=""><?php echo app('translator')->get('Iznos'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-6">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Ulazne fakture'); ?></h3>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12 d-flex justify-content-center">
                        <button class="btn btn-secondary" id="prev-date1">&#8592;</button> <!-- Strelica nazad -->
                        <div class="mx-2">
                            <input
                                type="text"
                                class="form-control text-center"
                                name="date_start1"
                                id="date_start1"
                                value=""
                            >
                        </div>
                        <button class="btn btn-secondary" id="next-date1">&#8594;</button> <!-- Strelica napred -->
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table1" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class=""><?php echo app('translator')->get('ID'); ?></th>
                                <th class=""><?php echo app('translator')->get('Firma'); ?></th>
                                <th class=""><?php echo app('translator')->get('Iznos'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
    
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-6">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Kamioni - Obaveze ( ' . \Carbon\Carbon::now()->locale('sr')->isoFormat('MMMM') . ' mjesec )'); ?></h3>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                </div>
                <div class="table-responsive">
                    <table class="table table-striped" id="entity-list-table1" class="display" style="width:100%">
                        <thead>
                            <tr>
                                <th class=""><?php echo app('translator')->get('Kamion'); ?></th>
                                <th class=""><?php echo app('translator')->get('Tablice'); ?></th>
                                <th class=""><?php echo app('translator')->get('Registracija'); ?></th>
                                <th class=""><?php echo app('translator')->get('Sestomjesecni'); ?></th>
                                <th class=""><?php echo app('translator')->get('PP Aparat'); ?></th>
                                <th class=""><?php echo app('translator')->get('Tahograf'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $trucks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $truck): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($truck->name); ?></td>
                                <td><?php echo e($truck->number_of_plates); ?></td>
                                
                                <td>
                                    
                                    <?php echo e(\Carbon\Carbon::parse($truck->registracija_end)->isCurrentMonth() ? $truck->registracija_end : ''); ?>

                                </td>
                                
                                <td>
                                    
                                    <?php echo e(\Carbon\Carbon::parse($truck->sestomjesecni_end)->isCurrentMonth() ? $truck->sestomjesecni_end : ''); ?>

                                </td>
                                
                                <td>
                                    
                                    <?php echo e(\Carbon\Carbon::parse($truck->pp_end)->isCurrentMonth() ? $truck->pp_end : ''); ?>

                                </td>
                                
                                <td>
                                    
                                    <?php echo e(\Carbon\Carbon::parse($truck->tahograf_end)->isCurrentMonth() ? $truck->tahograf_end : ''); ?>

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
</div>






<hr>
<div class="row">

    
    

    <div class="col-xl-2 col-md-6">
        
    </div><!-- end col -->

    <div class="col-xl-4 col-md-6">
        <div class="card widget-box-two widget-two-success">
            <div class="card-body">
                <i class="mdi mdi-cash widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-white text-uppercase font-600 font-secondary text-overflow" title="New Downloads">Ukupna zarada u 2025. godini</p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($zarada); ?> KM</span> <small></i></small></h2>
                    <p class="text-white m-0">Samo placene fakture</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-4 col-md-6">
        <div class="card widget-box-two widget-two-pink">
            <div class="card-body">
                <i class="mdi mdi-cash widget-two-icon"></i>
                <div class="wigdet-two-content">
                    <p class="m-0 text-uppercase text-white font-600 font-secondary text-overflow" title="Request Per Minute">Ukupni troskovi u 2025. godini</p>
                    <h2 class="text-white"><span data-plugin="counterup"><?php echo e($potrosnja); ?> KM</span> <small></small></h2>
                    <p class="text-white m-0">Samo placene fakture</p>
                </div>
            </div>
        </div>
    </div><!-- end col -->

    <div class="col-xl-2 col-md-6">
        
    </div><!-- end col -->

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script>
$(document).ready(function() {
    $("[data-plugin='knob']").knob();
});
</script>

<script src="<?php echo e(asset('/theme/plugins/jquery-knob/jquery.knob.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/waypoints/jquery.waypoints.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/counterup/jquery.counterup.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('/theme/plugins/jquery-knob/excanvas.js')); ?>"></script>

<script>
// Postavi današnji datum
const dateInput = document.getElementById('date_start');
const dateInput1 = document.getElementById('date_start1');
const today = new Date();
dateInput.value = formatDate(today);
dateInput1.value = formatDate(today);

var blade = {
        datatablesAjaxUrl1: "<?= route('truck.finance_datatable'); ?>",
        datatablesAjaxUrl2: "<?= route('truck.finance_datatable1'); ?>",
    };

// Funkcija za formatiranje datuma u DD-MM-YYYY
function formatDate(date) {
    const day = ("0" + date.getDate()).slice(-2);
    const month = ("0" + (date.getMonth() + 1)).slice(-2);
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
}

// Strelica napred - povećava datum za jedan dan
document.getElementById('next-date').addEventListener('click', function() {
    const currentDate = new Date(dateInput.value.split('-').reverse().join('-'));
    currentDate.setDate(currentDate.getDate() + 1);
    dateInput.value = formatDate(currentDate);
    table.ajax.reload(); // Osvježi tablicu nakon promjene datuma
});

// Strelica nazad - smanjuje datum za jedan dan
document.getElementById('prev-date').addEventListener('click', function() {
    const currentDate = new Date(dateInput.value.split('-').reverse().join('-'));
    currentDate.setDate(currentDate.getDate() - 1);
    dateInput.value = formatDate(currentDate);
    table.ajax.reload(); // Osvježi tablicu nakon promjene datuma
});

// Strelica napred - povećava datum za jedan dan
document.getElementById('next-date1').addEventListener('click', function() {
    const currentDate = new Date(dateInput1.value.split('-').reverse().join('-'));
    currentDate.setDate(currentDate.getDate() + 1);
    dateInput1.value = formatDate(currentDate);
    table1.ajax.reload(); // Osvježi tablicu nakon promjene datuma
});

// Strelica nazad - smanjuje datum za jedan dan
document.getElementById('prev-date1').addEventListener('click', function() {
    const currentDate = new Date(dateInput1.value.split('-').reverse().join('-'));
    currentDate.setDate(currentDate.getDate() - 1);
    dateInput1.value = formatDate(currentDate);
    table1.ajax.reload(); // Osvježi tablicu nakon promjene datuma
});

// Postavi DataTables
var table = $('#entity-list-table').DataTable({
    "autoWidth": true,
    "processing": true,
    "serverSide": true,
    "paging": false, // Onemogućava paginaciju
    "info": false, // Onemogućava informacije o prikazu
    "language": {
            emptyTable: "Nije pronađena ni jedna faktura za današnji datum"
        },
    "searching": false,
    "ajax": {
        url: blade.datatablesAjaxUrl1,
        type: "post",
        data: function(d) {
            d.date_start = $('#date_start').val(); // Pošalji trenutni datum
        }
    },
    "columns": [
        {"data": "id_invoice", orderable: false, "className": ""},
        {"data": "company", orderable: false, "className": ""},
        {"data": "price", orderable: false, "className": ""},
    ],
    "order": [[0, "asc"]],
});

var table1 = $('#entity-list-table1').DataTable({
    "autoWidth": true,
    "processing": true,
    "serverSide": true,
    "paging": false, // Onemogućava paginaciju
    "info": false, // Onemogućava informacije o prikazu
    "language": {
            emptyTable: "Nije pronađena ni jedna faktura za današnji datum"
        },
    "searching": false,
    "ajax": {
        url: blade.datatablesAjaxUrl2,
        type: "post",
        data: function(d) {
            d.date_start1 = $('#date_start1').val(); // Pošalji trenutni datum
        }
    },
    "columns": [
        {"data": "id_invoice", orderable: false, "className": ""},
        {"data": "company", orderable: false, "className": ""},
        {"data": "price", orderable: false, "className": ""},
    ],
    "order": [[0, "asc"]],
});

</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/truck/finances.blade.php ENDPATH**/ ?>