<?php $__env->startSection('head_title', __('Grupe Korisnika') . ' - ' . __('Korisnici Programa')); ?>

<?php $__env->startPush('head_links'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Grupe Korisnika"),
    'breadcrumbs' => [
        route('groups.index') => __('Korisnici Programa')
    ]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row">
    <div class="col-md-12">
    <div class="card">
        <div class="card-heading d-flex justify-content-between">
            <div class="card-heading-title">
                <h3 class="card-title"><?php echo app('translator')->get('Grupa Korisnika'); ?></h3>
            </div>
            <div class="card-heading-actions">
                <a href="<?php echo e(route('groups.create')); ?>" class="btn btn-primary">
                    <i class="fa fa-plus mr-2"></i>
                    <?php echo app('translator')->get('Dodaj'); ?>
                </a>
                <!-- end:title-toolbar  -->
            </div>
        </div>
        <div class="card-body">
            <div class="material-datatables">
                <table id="entity-list-table" class="table table-striped table-no-bordered table-hover" cellspacing="0" width="100%" style="width:100%">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('Ime'); ?></th>
                        <th><?php echo app('translator')->get('Opis'); ?></th>
                        <th class="disabled-sorting text-right"><?php echo app('translator')->get('Opcije'); ?></th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
            </div>
        </div>
        <!-- end content-->
    </div>
    <!--  end card  -->
    </div>
    <!-- end col-md-12 -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script type="text/javascript">
    var table = $('#entity-list-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: "<?= route('groups.datatable'); ?>",
            type: "POST",
        },
        "columns": [
            {"data": "name"},
            {"data": "description"},
            {"data": "actions", orderable: false, searchable: false, "className": "text-right"}
        ],
    });

    // DELETE MODAL
    let options = {
        "title": "Obriši",
        "liveSelector": '[data-action="delete"]'
    };
    
    $('#entity-list-table').questionPop(options).on('success.qp', function() {
        $('#entity-list-table').DataTable().draw('page');
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/groups/index.blade.php ENDPATH**/ ?>