<?php $__env->startPush('head_scripts'); ?>
    <link href="<?php echo e(asset('/theme/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopPush(); ?>
<!-- begin:form -->
<style>
    .accordion .card{
    border: none
    }
    .accordion .card-heading{
    min-height: 40px
    }
    .card-heading .checkbox label, .card-heading .radio label{
    color:#fff;
    margin-bottom: 0;
    } 
</style>

<form id="groups-form" method="POST" class="form-horizontal" enctype="multipart/form-data">
    <?php echo e(csrf_field()); ?>

    <div class="form-group row">
        <label class="col-md-2 control-label">
            <?php echo app('translator')->get('Ime'); ?>
            <span class="text-danger">*</span>
        </label>
        <div class="col-md-6">
            <input type="text" name="name" value="<?php echo e(old('name', $entity->name)); ?>" class="form-control" placeholder="<?php echo app('translator')->get('Enter a Name'); ?>" autofocus maxlength="100">
            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <div class="form-group row">
        <?php if (! (empty($permissions))): ?>
            <label class="col-md-2 control-label">
                <?php echo app('translator')->get('Permisije'); ?>
                <span class="text-danger">*</span>
            </label>
            <div class="col-md-6">
                <div class="accordion" id="accordion-test-2">
                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $permissionGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card mb-2">
                            <?php if($permissionGroup['id'] != 'korisnici_programa' || !auth()->user()->hasGroup($entity->slug)): ?>
                                <div class="card-heading">
                                    <div class="checkbox d-inline-block">
                                        <label>
                                            <input class="collapsed" 
                                                   data-toggle="collapse" 
                                                   data-target="#group-<?php echo e($permissionGroup['id']); ?>" 
                                                   aria-controls="group-<?php echo e($permissionGroup['id']); ?>" 
                                                   type="checkbox" 
                                                   name="permissions[<?php echo e($permissionGroup['id']); ?>][]" 
                                                   value="<?php echo e($permissionGroup['children'][0]['id']); ?>" 
                                                   <?php if(in_array($permissionGroup['children'][0]['id'], $usedPermissions)): ?> checked <?php endif; ?>>
                                            <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                            <?php echo e($permissionGroup['children'][0]['text']); ?>

                                        </label>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="card-heading">
                                    <div class="checkbox d-inline-block">
                                        <label>
                                            <input class="collapsed" 
                                                   disabled=""
                                                   data-toggle="collapse" 
                                                   data-target="#group-<?php echo e($permissionGroup['id']); ?>" 
                                                   aria-controls="group-<?php echo e($permissionGroup['id']); ?>" 
                                                   type="checkbox" 
                                                   name="permissions[<?php echo e($permissionGroup['id']); ?>][]" 
                                                   value="<?php echo e($permissionGroup['children'][0]['id']); ?>" 
                                                   <?php if(in_array($permissionGroup['children'][0]['id'], $usedPermissions)): ?> checked <?php endif; ?>>
                                            <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                            <?php echo e($permissionGroup['children'][0]['text']); ?>

                                        </label>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div id="group-<?php echo e($permissionGroup['id']); ?>" 
                                 class="collapse <?php if(in_array($permissionGroup['children'][0]['id'], $usedPermissions)): ?> show <?php endif; ?>" 
                                 >
                                <?php if(count($permissionGroup['children']) > 1): ?>
                                <div class="card-body py-0 text-right">
                                    <div class="checkbox d-inline-block">
                                        <label>
                                            <input type="checkbox" name="permissions[<?php echo e($permissionGroup['id']); ?>][]children" value="*">
                                            <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                            <?php echo app('translator')->get('Izaberi sve'); ?>
                                        </label>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <div class="card-body">
                                        <?php $__currentLoopData = array_slice($permissionGroup['children']->toArray(), 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($permission['text'] != "Grupe"  || !auth()->user()->hasGroup($entity->slug)): ?>
                                                <div class="checkbox d-inline-block col-md-5">
                                                    <label>
                                                        <input type="checkbox" name="permissions[<?php echo e($permissionGroup['id']); ?>][]children" value="<?php echo e($permission['id']); ?>" <?php if(in_array($permission['id'], $usedPermissions)): ?> checked <?php endif; ?>>
                                                        <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                        <?php echo e($permission['text']); ?>

                                                    </label>
                                                </div>
                                                &nbsp;
                                            <?php else: ?>
                                                <div class="checkbox d-inline-block col-md-5">
                                                    <label>
                                                        <input disabled="" checked="" type="checkbox" name="permissions[<?php echo e($permissionGroup['id']); ?>][]" value="<?php echo e($permission['id']); ?>" <?php if(in_array($permission['id'], $usedPermissions)): ?> checked <?php endif; ?>>
                                                        <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                        <?php echo e($permission['text']); ?>

                                                    </label>
                                                </div>
                                                &nbsp;
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>
        <?php echo $__env->make('_layout.partials.form.error', ['field' => 'permissions'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="form-group row">
        <label class="col-md-2 control-label">
            <?php echo app('translator')->get('Opis'); ?>
        </label>
        <div class="col-md-6">
            <textarea name="description" placeholder="<?php echo app('translator')->get('Enter a description'); ?>" class="form-control" rows="5" maxlength="655"><?php echo e(old('description', $entity->description)); ?></textarea>
            <?php echo $__env->make('_layout.partials.form.error', ['field' => 'description'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
    <div class="form-group row">
        <div class="offset-md-2 col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                <?php echo app('translator')->get('Sačuvaj'); ?>
            </button>
        </div>
    </div>
</form>
<!-- end:form -->
<?php $__env->startPush('footer_scripts'); ?>
    <!-- begin:page script -->
    <script src="<?php echo e(asset('/theme/plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/theme/plugins/bootstrap-maxlength/bootstrap-maxlength.min.js')); ?>"></script>
    <script type="text/javascript">
        $('#groups-form textarea').maxlength({
            threshold: 655,
            placement: 'right'
        });

        $('#groups-form :text').maxlength({
            threshold: 100,
            placement: 'right'
        });

        $('input[name^=permissions]').change(function(e) {
            let $t = $(this);
            let thisPermissionGroup = $(`input[name="${$t.attr('name')}"]`);
            if($(this).val() == '*') {
                thisPermissionGroup.prop('checked', $t.prop('checked'));
            } else if($(this).attr('data-toggle') == 'collapse') {
                $(`input[name="${$t.attr('name')}children"]`).prop('checked', false);
            } else {
                let total = thisPermissionGroup.length;
                let checkedTotal = $(`input[name="${$t.attr('name')}"]:checked`).length;
                if(total != checkedTotal) {
                    $(`input[name="${$t.attr('name')}"][value="*"]`).prop('checked', false);
                }
            }
        });

        $("#groups-form").validate({
            rules: {
                name: {
                    required: true,
                    rangelength: [3, 100]
                },
                permissions: {
                    required: true
                },
                description: {
                    required: false,
                    rangelength: [10, 655]
                }
            }
        });

        $('#groups-form').submit(function(e) {
            $(`input[value="*"]`).remove();
        });
    </script>
    <!-- begin:page script -->
<?php $__env->stopPush(); ?><?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/groups/partials/form.blade.php ENDPATH**/ ?>