<?php $__env->startSection('head_title', __('Pregled / Izmena Profila') . ' - ' . __('Profil') . ' - ' . __('Podesavanja')); ?>

<?php $__env->startPush('head_links'); ?>
    <link href="<?php echo e(asset('/theme/plugins/bootstrap-select/css/bootstrap-select.min.css')); ?>" rel="stylesheet"> 
    <link href="<?php echo e(asset('/theme/plugins/bootstrap-tagsinput/css/bootstrap-tagsinput.css')); ?>" rel="stylesheet">
    <style>
        .contact-detail {
            border-bottom: 1px solid whitesmoke;
        }
        .bootstrap-tagsinput {
            border: none !important;
            cursor: default;
        }
        .tag.badge.badge-info > span {
            display: none; !important;
        }
        .bootstrap-tagsinput input {
            cursor: default; 
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>



<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title"><?php echo app('translator')->get('Profil'); ?></h3>
                    <p class="card-sub-title text-muted">
                        &nbsp;
                    </p>
                </div>
                <div class="card-heading-actions">
                    <a href="<?php echo e(route('profile.edit_password')); ?>" class="btn btn-warning">
                        <i class="fa fa-user-secret"></i>
                        <?php echo app('translator')->get('Izmeni Lozinku'); ?>
                    </a>
                    <a href="<?php echo e(route('truck.invoices')); ?>" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i>
                        <?php echo app('translator')->get('Nazad'); ?>
                    </a>
                </div>
            </div>

            <div class="card-body">
                <div class="row justify-content-around">
                    <!-- PROFIL INFO START -->
                    <div class="col-lg-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="text-center member-box">
                                    <div class="member-card">
                                        <div class="thumb-xl member-thumb m-b-10 mx-auto d-block">
                                            <img src="<?php echo e(auth()->user()->getProfileImg() ?? config('newscms.default_profile_img_src')); ?>" class="rounded-circle img-thumbnail" alt="<?php echo e(__('Profilna slika')); ?>">
                                            <i class="mdi mdi-star-circle member-star text-muted" title="unverified user"></i>
                                        </div>

                                        <div>
                                            <h4 class="m-b-5"><?php echo e(auth()->user()->getFullName()); ?></h4>
                                            <p class="mb-3"><span class="text-pink"></span></p>
                                        </div>

                                        <div class="contact-box">

                                            <div class="contact-detail">
                                                <i class=" mdi mdi-cellphone-iphone"></i>
                                                <?php if(auth()->user()->phone): ?>
                                                    <?php echo e(auth()->user()->phone); ?>

                                                <?php else: ?>
                                                    &nbsp;
                                                <?php endif; ?>
                                            </div>

                                            <div class="contact-detail">
                                                <i class="mdi mdi-email"></i>
                                                <?php echo e(auth()->user()->email); ?>

                                            </div>

                                        </div>

                                        <p class="text-muted"><?php echo app('translator')->get('Svi website-ovi nad kojima je dozvoljen pristup:'); ?></p>
                                        <div class="m-b-0">
                                            <select multiple data-role="tagsinput" class="d-none" disabled>
                                                <?php $__currentLoopData = auth()->user()->getWebsites(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $website): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($website->short_title); ?>"><?php echo e($website->short_title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>                
                    <!-- PROFIL INFO KRAJ -->

                    <!-- IZMENA PODATAKA START -->
                    <div class="col-lg-7 d-flex align-items-center">
                        <?php echo $__env->make('profile.partials.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <!-- IZMENA PODATAKA KRAJ -->
                </div> <!-- end row -->
            </div> <!-- end card-body -->

        </div> <!-- end card -->
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-select/js/bootstrap-select.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-tagsinput/js/bootstrap-tagsinput.min.js')); ?>"></script>
<script>
$(function() {
    // onemogucava 'mouse click' nad 'select tags' elementom (sve poslovne jedinice) 
    // zbog prikaza kursora koji ne bi trebalo da se prikazuje.
    $('.bootstrap-tagsinput input').prop('disabled', true);
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('_layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/profile/edit.blade.php ENDPATH**/ ?>