<div class="card">
    <div class="card-heading d-flex justify-content-between align-items-center">
        <div class="card-heading-title">
            <h3 class="card-title"><?php echo app('translator')->get('Lista Komentara'); ?></h3>
        </div>
        <div class="card-heading-actions form-group mb-0 row align-items-center justify-content-end">
            <!-- Akcija za brzi edit -->
            <label class="col-sm-4 text-right control-label px-0 mb-0"><?php echo app('translator')->get('Brza pretraga'); ?></label>
            <div class="col-sm-3 pl-1">
                <input id="fast-search" class="form-control input-sm" placeholder="ID" value="">
            </div>
        </div>
    </div>
    <hr>
    <div class="card-body">
        <form action="" id="entities-filter-form2" method="post" class="form" autocomplete="off">
            <div class="row">
                <input type="hidden" name="article_id" value="" id="article-id"></input>
                <div class="col-lg-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Period'); ?></label>
                        <select name="edition" class="form-control selectpicker" 
                                data-live-search="true" data-size="5"
                                >
                            <option value="1"><?php echo app('translator')->get('Danasnji'); ?></option>
                            <option value="2"><?php echo app('translator')->get('Poslednja 2 dana'); ?></option>
                            <option value="7"><?php echo app('translator')->get('Poslednjih 7 dana'); ?></option>
                            <option value="0"><?php echo app('translator')->get('Sve vreme'); ?></option>
                        </select>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Status'); ?></label>
                        <select name="status" class="form-control selectpicker" 
                                data-live-search="true" data-size="5"
                                >
                            <option value="<?php echo e(App\Models\ArticleComment::NEW_STATUS); ?>"><?php echo app('translator')->get('Novi'); ?></option>
                            <option value="<?php echo e(App\Models\ArticleComment::APPROVED_STATUS); ?>"><?php echo app('translator')->get('Odobreni'); ?></option>
                            <option value="<?php echo e(App\Models\ArticleComment::BANNED_STATUS); ?>"><?php echo app('translator')->get('Zabranjeni'); ?></option>
                            <option value="0"><?php echo app('translator')->get('Svi komentari'); ?></option>
                        </select>
                    </div>
                </div>
            </div>
        </form>
        <div id="article-comments" class="mws-form-inline">

        </div>
    </div>
</div>
<?php $__env->startPush('footer_scripts'); ?>
<script>
    $('#entities-filter-form2').on('change', function () {
        var formData = {};

        $(this).find('[name]').each(function (index, element) {
            let name = $(element).attr('name');
            let value = $(element).val();
            formData[name] = value;
        });

        $.ajax({
            "url": "<?php echo e(route('comments.comments')); ?>",
            "type": "GET",
            "data": formData
        }).done(function (response) {
            $('#article-comments').html(response.html);
        });
    }).trigger('change');

    $('#fast-search').on('input', function (e) {
        let articleId = $(this).val();
        $('#article-id').val(articleId);
        $('#entities-filter-form2').change();
    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/comments/partials/list_comments.blade.php ENDPATH**/ ?>