<?php $__env->startPush('head_links'); ?>
<link href="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<style>
    .spacer {
        margin-top: 8px;
    }

    .form-group {
        margin-bottom: 16px;
    }

    .date-yellow {
    background-color: yellow;
    }

    .date-red {
        background-color: red;
        color: white;
    }
</style>

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            <?php echo csrf_field(); ?>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Proizvodjač'); ?><sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("producer") ? 'is-invalid' : ""; ?>" 
                        name="producer" 
                        placeholder="<?php echo app('translator')->get('Proizvodjač'); ?>" 
                        value="<?php echo e(old('producer', $entity->producer)); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'producer'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Naziv vozila'); ?><sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("name") ? 'is-invalid' : ""; ?>" 
                        name="name" 
                        placeholder="<?php echo app('translator')->get('Naziv vozila'); ?>" 
                        value="<?php echo e(old('name', $entity->name)); ?>"
                    >
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Broj saobraćajne'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("phone") ? 'is-invalid' : ""; ?>" 
                        name="traffic_number" 
                        placeholder="<?php echo app('translator')->get('Broj saobraćajne'); ?>" 
                        value="<?php echo e(old('traffic_number', $entity->traffic_number)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-credit-card"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'traffic_number'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label"><?php echo app('translator')->get('Tablice'); ?></label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control <?= $errors->has("number_of_plates") ? 'is-invalid' : ""; ?>" 
                        name="number_of_plates" 
                        placeholder="<?php echo app('translator')->get('Tablice'); ?>" 
                        value="<?php echo e(old('number_of_plates', $entity->number_of_plates)); ?>"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-solid fa-truck"></i>
                        </span>
                    </span>
                    <?php echo $__env->make('_layout.partials.form.error', ['field' => 'number_of_plates'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
            </div>
            
        </div>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

        <div class="col-lg-5 d-flex justify-content-center align-items-center">
            <div class="d-flex align-items-center">
                <i class="fas fa-gas-pump fa-3x me-4"></i> 
                <div style="margin:30px;">
                    <h5><?php echo app('translator')->get('Potrošnja goriva'); ?></h5>
                    <p><?php echo app('translator')->get('Mesečna potrošnja'); ?>: <strong>000 L</strong></p>
                    <p><?php echo app('translator')->get('Godišnja potrošnja'); ?>: <strong>000 L</strong></p>
                </div>
            </div>
        </div>
    </div>
    <hr>

    <div class="row">
        <!-- Registracija -->
        <div class="col-lg-3">
            <div class="form-group">
                <label class="control-label"><?php echo app('translator')->get('Registracija'); ?></label>
                <input type="text" class="form-control text-center enterable" name="registracija_start" id="registracija_start" placeholder="<?php echo app('translator')->get('Datum'); ?>" value="<?php echo e(old('registracija_start', !empty($entity->registracija_start) ? date('d-m-Y', strtotime($entity->registracija_start)) : "")); ?>">
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'registracija_start'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="spacer"></div>
                <input type="text" class="form-control text-center enterable" name="registracija_end" id="registracija_end" placeholder="<?php echo app('translator')->get('Datum'); ?>" value="<?php echo e(old('registracija_end', !empty($entity->registracija_end) ? date('d-m-Y', strtotime($entity->registracija_end)) : "")); ?>">
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'registracija_end'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <!-- Sestomesecni -->
        <div class="col-lg-3">
            <div class="form-group">
                <label class="control-label"><?php echo app('translator')->get('Sestomesecni'); ?></label>
                <input type="text" class="form-control text-center enterable" name="sestomjesecni_start" id="sestomjesecni_start" placeholder="<?php echo app('translator')->get('Datum'); ?>" value="<?php echo e(old('sestomjesecni_start', !empty($entity->sestomjesecni_start) ? date('d-m-Y', strtotime($entity->sestomjesecni_start)) : "")); ?>">
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'sestomjesecni_start'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="spacer"></div>
                <input type="text" class="form-control text-center enterable" name="sestomjesecni_end" id="sestomjesecni_end" placeholder="<?php echo app('translator')->get('Datum'); ?>" value="<?php echo e(old('sestomjesecni_end', !empty($entity->registracija_end) ? date('d-m-Y', strtotime($entity->sestomjesecni_end)) : "")); ?>">
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'sestomjesecni_end'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <!-- PP Aparati -->
        <div class="col-lg-3">
            <div class="form-group">
                <label class="control-label"><?php echo app('translator')->get('PP Aparati'); ?></label>
                <input type="text" class="form-control text-center enterable" name="pp_start" id="pp_start" placeholder="<?php echo app('translator')->get('Datum'); ?>" value="<?php echo e(old('pp_start', !empty($entity->pp_start) ? date('d-m-Y', strtotime($entity->pp_start)) : "")); ?>">
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'pp_start'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="spacer"></div>
                <input type="text" class="form-control text-center enterable" name="pp_end" id="pp_end" placeholder="<?php echo app('translator')->get('Datum'); ?>" value="<?php echo e(old('pp_end', !empty($entity->pp_end) ? date('d-m-Y', strtotime($entity->pp_end)) : "")); ?>">
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'pp_end'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <!-- Tahograf -->
        <div class="col-lg-3">
            <div class="form-group">
                <label class="control-label"><?php echo app('translator')->get('Tahograf'); ?></label>
                <input type="text" class="form-control text-center enterable" name="tahograf_start" id="tahograf_start" placeholder="<?php echo app('translator')->get('Datum'); ?>" value="<?php echo e(old('tahograf_start', !empty($entity->tahograf_start) ? date('d-m-Y', strtotime($entity->tahograf_start)) : "")); ?>">
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'tahograf_start'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="spacer"></div>
                <input type="text" class="form-control text-center enterable" name="tahograf_end" id="tahograf_end" placeholder="<?php echo app('translator')->get('Datum'); ?>" value="<?php echo e(old('tahograf_end', !empty($entity->tahograf_end) ? date('d-m-Y', strtotime($entity->tahograf_end)) : "")); ?>">
                <?php echo $__env->make('_layout.partials.form.error', ['field' => 'tahograf_end'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
    
    <style>
        .spacer {
            margin-top: 8px;
        }
    </style>
    
    
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                <?php echo app('translator')->get('Sačuvaj'); ?>
            </button>
        </div>
    </div>
</form>

<?php $__env->startPush('footer_scripts'); ?>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')); ?>"></script>
<script src="<?php echo e(asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')); ?>"></script>
<script>
$(function() {

    $(document).ready(function() {
    // Initialize datepickers with the specified format and options
    $('input[name$="_start"], input[name$="_end"]').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        todayHighlight: true
    });

    // Custom validator to ensure date_start is not greater than date_end
    $.validator.addMethod("greaterStart", function(value, element, params) {
        let startDate = $(params[0]).val().split("-");
        let endDate = $(params[1]).val().split("-");
        let start = new Date(startDate[2], startDate[1] - 1, startDate[0]);
        let end = new Date(endDate[2], endDate[1] - 1, endDate[0]);
        return this.optional(element) || start <= end;
    }, "<?php echo e(__('Datum mora biti veći od datuma početka.')); ?>");

    // Apply validation rules
    $("#entity-form").validate({
        rules: {
            registracija_end: { greaterStart: ['#registracija_start', '#registracija_end'] },
            sestomjesecni_end: { greaterStart: ['#sestomjesecni_start', '#sestomjesecni_end'] },
            pp_end: { greaterStart: ['#pp_start', '#pp_end'] },
            tahograf_end: { greaterStart: ['#tahograf_start', '#tahograf_end'] }
        }
    });
});

    $(document).ready(function() {
        // Funkcija koja proverava datum i menja boju inputa
        function applyDateColor(inputId, dateStr) {
            var today = moment(); // trenutni datum
            var dateEnd = moment(dateStr, 'D-M-YYYY'); // parsiramo datum iz inputa

            if (!dateEnd.isValid()) return; // ako datum nije validan, ne radimo ništa

            // Uklanjamo prethodne klase
            $('#' + inputId).removeClass('date-yellow date-red');

            // Ako je datum istekao ili je danas
            if (today.isSameOrAfter(dateEnd, 'day')) {
                $('#' + inputId).addClass('date-red'); // postavljamo crvenu boju
            }
            // Ako je datum u poslednjih 7 dana
            else if (today.isSameOrAfter(dateEnd.clone().subtract(7, 'days'), 'day') && today.isBefore(dateEnd, 'day')) {
                $('#' + inputId).addClass('date-yellow'); // postavljamo žutu boju
            }
        }

        // Proveravamo datum za svaki relevantni input
        applyDateColor('registracija_end', $('#registracija_end').val());
        applyDateColor('sestomjesecni_end', $('#sestomjesecni_end').val());
        applyDateColor('pp_end', $('#pp_end').val());
        applyDateColor('tahograf_end', $('#tahograf_end').val());

        // Event listener za promenu datuma, kako bi se boje ažurirale ako korisnik menja datum
        $('#registracija_end, #sestomjesecni_end, #pp_end, #tahograf_end').on('change', function() {
            applyDateColor(this.id, $(this).val());
        });
    });

    
    $(document).ready(function() {
    $('#entity-form').validate({
        rules: {
            producer: {
                required: true
            },
            name: {
                required: true
            },
            traffic_number: {
                required: true,
                maxlength: 20
            },
            tahograf_start: {
                required: true,
                date: true
            },
            tahograf_end: {
                required: true,
                date: true
            }
        },
        messages: {
            
        },
    });
});

});
</script>
<?php $__env->stopPush(); ?><?php /**PATH /opt/cms/resources/views/truck/trucks/partials/form.blade.php ENDPATH**/ ?>