<?php
namespace App\Exports;

use App\Models\FirestoreUser;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class FullAndUnlimitedExport implements FromCollection,WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function headings():array{
        return[
            'email',
            'subscription',
            'name',
            'lastName',
            'street',
            'streetNumber',
            'city',
            'country'
        ];
    }
    public function collection()
    {
        return FirestoreUser::select('email','subscription','name','lastName','street','streetNumber','city','country')
                ->whereIn('subscription',['full', 'unlimited'])
                ->get();
    }
}
