<?php

namespace App\Models\Truck;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use App\Models\User;


class Procurement extends Model
{
    use SoftDeletes;
    protected $table = 'truck_procurement';

    protected $fillable = [
        'id_invoice', 
        'text', 
        'company', 
        'date_start', 
        'date_end', 
        'date_done', 
        'price', 
        'price_part',
        'currency', 
        // 'truck', 
        'status'];

public static function boot()
{
    parent::boot();

    static::saving(function ($model) {
        $model->debt = ($model->price ?: 0) - ($model->price_part ?: 0);
    });

    static::updating(function ($model) {
        $model->debt = ($model->price ?: 0) - ($model->price_part ?: 0);
    });
}

// protected static function boot()
// {
//     parent::boot();

//     static::creating(function ($model) {
//         $model->created_by = Auth::id();
//         $model->updated_by = Auth::id();
//     });

//     static::updating(function ($model) {
//         $model->updated_by = Auth::id();
//     });
// }

// public function creator()
// {
//     return $this->belongsTo(User::class, 'created_by');
// }

// public function updater()
// {
//     return $this->belongsTo(User::class, 'updated_by');
// }
    
public function company()
{
    return $this->belongsTo(CompanyProcurement::class, 'company_id');
}
}
