(function () {
    CKEDITOR.plugins.add('mediaVideo', {
        icons: 'medialibraryvideo', // %REMOVE_LINE_CORE%
        hidpi: true, // %REMOVE_LINE_CORE%
        init: function (editor) {
            var mediaVideo = this;
            var videoModal = getVideoModal();

            editor.addCommand('MediaVideo', {
                exec: function (editor) {
                    var selectedElement = editor.getSelection().getStartElement();
                    var videoId = null;

                    if (selectedElement && selectedElement.hasAttribute('v_id')) {
                        videoId = selectedElement.getAttribute('v_id');
                    }
                    videoModal.openModal(videoId, function (video) {
                        var videoContainerHtml = `<p><img alt="" data-video v_id="${video.entityId}" src="/custom/ckeditor/plugins/mediaVideo/video.png" style="display: block; width: 100%;"/></p>`;
                        editor.insertHtml(videoContainerHtml);
                        editor.focus();
                    });
                }
            });

            editor.ui.addButton('MediaVideo', {
                label: 'Video',
                command: 'MediaVideo',
                icon: 'medialibraryvideo',
                toolbar: 'mediaVideo'
            });

            editor.on('doubleclick', function (evt) {
                var element = evt.data.element;

                if (element && element.is('img')) {
                    if (element.hasAttribute('data-video')) {
                        evt.cancel();
                        editor.execCommand('MediaVideo');
                    }
                }
            });

            if (editor.contextMenu) {
                editor.addMenuGroup('mediaVideo');

                editor.contextMenu.addListener(function (element, selection) {
                    if (element.hasAttribute('data-video')) {
                        editor.contextMenu.removeAll();
                        editor.addMenuItems({
                            MediaVideoEdit: {
                                label: 'Izmeni Video',
                                icon: 'medialibraryvideo',
                                command: 'MediaVideo',
                                group: 'mediaVideo',
                                order: 1
                            },
                            DeleteLatestDiv: {
        	                    label : 'Obriši okvir',
        	                    command : 'deleteLatestDiv',
        	                    group : 'news',
        	                    order : 2
        					}
                        });

                        return {
                            MediaVideoEdit: CKEDITOR.TRISTATE_ON,
                            DeleteLatestDiv: CKEDITOR.TRISTATE_ON
                        };
                    } else if (selection.getType() == CKEDITOR.SELECTION_NONE || selection.getType() == CKEDITOR.SELECTION_TEXT) {
                        editor.addMenuItems({
                            MediaVideo: {
                                label: 'Ubaci Video',
                                icon: 'medialibraryvideo',
                                command: 'MediaVideo',
                                group: 'mediaVideo',
                                order: 94
                            }
                        });

                        return {
                            MediaVideo: CKEDITOR.TRISTATE_OFF
                        };
                    }
                });
            }
        }
    });
})();