
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */
require('./bootstrap');

window.Vue = require('vue');
window.axios = require('axios');

var localeLang = 'sr_Latin';

import axios from 'axios'
import VueAxios from 'vue-axios'
import VueSimpleAlert from "vue-simple-alert";


Vue.use(VueAxios, axios)
Vue.use(require('vue-moment'));


Vue.use(VueSimpleAlert);

// Import validacionog 'plugin'-a i validacionih pravila
import { ValidationProvider, ValidationObserver, extend } from 'vee-validate';
import * as rules from 'vee-validate/dist/rules';
import { customRules, customRulesMessages } from './validators';
import sr_Latin from 'vee-validate/dist/locale/sr_Latin';
import en from 'vee-validate/dist/locale/en';

// koristi 'vee validate lang' objekat na osnovu trenutnog lokala.
var veeValidateLangObj = ((lang) => {
  if(lang == 'sr_Latin') {
    return sr_Latin
  }
  else if(lang == 'en') {
    return en;
  }
})(localeLang);

// lista svih validacionih pravila:
// { alpha$1 as alpha, alpha_dash, alpha_num, alpha_spaces, between, confirmed, digits, dimensions, email, 
//   excluded, ext, image, integer, is, is_not, length, max, max_value, mimes, min, min_value, numeric, oneOf, 
//   regex, required, required_if, size };

// prijavi sva validaciona pravila
for (let rule in rules) {
  extend(rule, {
    ...rules[rule],
    message: veeValidateLangObj.messages[rule]
  });
}

// prijavi sva 'custom' validaciona pravila
for (let rule in customRules) {
  extend(rule, {
    ...customRules[rule],
    message: customRulesMessages[rule][localeLang]
  });
}

Vue.component('validation-provider', ValidationProvider);
Vue.component('validation-observer', ValidationObserver);

 // basic components
Vue.component('example-component', require('./components/ExampleComponent.vue').default);

// wrapped components
Vue.component('newscms-select2', require('./components/wrapped/Select2Component.vue').default);
Vue.component('newscms-selectpicker', require('./components/wrapped/SelectpickerComponent.vue').default);
Vue.component('newscms-daterangepicker', require('./components/wrapped/DateRangepickerComponent.vue').default);
Vue.component('newscms-tags-select', require('./components/wrapped/TagsSelectComponent.vue').default);
Vue.component('newscms-autocomplete', require('./components/wrapped/AutocompleteComponent.vue').default);

// media library components
Vue.component('ml-search-tab', require('./components/media_library/SearchTabContentComponent.vue').default);
Vue.component('ml-upload-tab', require('./components/media_library/UploadTabContentComponent.vue').default);
Vue.component('ml-upload-tab-photo', require('./components/media_library/UploadTabPhotoComponent.vue').default);
Vue.component('ml-edit-tab', require('./components/media_library/EditTabContentComponent.vue').default);
Vue.component('ml-select-photo-tab', require('./components/media_library/SelectPhotoTabContentComponent.vue').default);
Vue.component('ml-photo-gallery-tab', require('./components/media_library/PhotoGalleryTabContentComponent.vue').default);
Vue.component('ml-photo-gallery-item', require('./components/media_library/PhotoGalleryItemComponent.vue').default);
Vue.component('ml-search-tab-datatable', require('./components/media_library/SearchTabDatatableComponent.vue').default);
Vue.component('ml-insert-photo-buttons', require('./components/media_library/InsertPhotoButtonsComponent.vue').default);

