@push('head_links')
<style>
    .cursor-pointer {
        cursor: pointer;
    }
</style>
@endpush
<fieldset>
    <legend class="p-3 mt-5 bg-light" style="font-size: 1rem;">
        <div class="d-flex justify-content-between align-items-center">
            <span class="h4">@lang('Kategorije')</span>
            <small>
                <a href="javascript:;" class="btn btn-secondary btn-small boolean-selectors select-all-cats">
                    <span class="fa fa-check mr-1"></span>
                    @lang('Selektuj sve')
                </a>
                |
                <a href="javascript:;" class="btn btn-secondary btn-small boolean-selectors unselect-all-cats">
                    <span class="fa fa-remove mr-1"></span>
                    @lang('Obriši izbor')
                </a>
            </small>
        </div>
        <input id="categories-error" type="hidden" class="form-control @errorClass('categories', 'is-invalid')">
        @formError(['field' => 'categories'])
        <input id="subcategories-error" type="hidden" class="form-control @errorClass('subcategories', 'is-invalid')">
        @formError(['field' => 'subcategories'])
    </legend>
    <div class="form-group row">
        <div class="col-12">
            <ul class="list-unstyled categories-and-subcategories">
                @foreach($categories as $category)
                <li class="mt-3">
                    <div class="form-check">
                    <input 
                        class="form-check-input category-input" 
                        type="checkbox" 
                        value="{{$category->id}}" 
                        name="categories[]"
                        data-error-placement="categories-error" 
                        id="category_{{$category->id}}"
                        @if(in_array((string) $category->id, old('categories', $entity->categories()))) checked @endif
                    >
                        <label class="form-check-label cursor-pointer" for="category_{{$category->id}}">
                            {{$category->name}}
                        </label>
                    </div>
                    @if((property_exists($category, 'children') || method_exists($category, 'children')) && $category->children->count())
                    <ul class="list-unstyled">
                        @foreach($category->children as $subcategory)
                        <li class="mt-2 ml-4">
                            <div class="form-check">
                                <input 
                                class="form-check-input subcategory-input" 
                                type="checkbox" 
                                value="{{$subcategory->id}}" 
                                name="subcategories[]" 
                                data-error-placement="subcategories-error"
                                id="subcategory_{{$subcategory->id}}"
                                @if(in_array((string) $subcategory->id, old('subcategories', $entity->subcategories()))) checked @endif
                                >
                                <label class="form-check-label cursor-pointer" for="subcategory_{{$subcategory->id}}">
                                    {{$subcategory->name}}
                                </label>
                            </div>
                        </li>
                        @endforeach
                    </ul>
                    @endif
                    <hr>
                </li>
                @endforeach
            </ul>
        </div>
    </div>
</fieldset>
@push('footer_scripts')
<script>
    $(document).ready(function(){
        $('a.boolean-selectors').on('click', function(e){
            e.preventDefault();
            let cats = $('ul.categories-and-subcategories input[type="checkbox"]');
            let selectAll = $(this).hasClass('select-all-cats');
            let unselectAll = $(this).hasClass('unselect-all-cats');
            $.each(cats, function(key, item){
                if(selectAll){
                    $(this).prop('checked', true);
                }
                if(unselectAll){
                    $(this).prop('checked', false);
                }
            });

        });
    });
</script>
@endpush