{{-- @if(!empty($entity->filename)) --}}
@if(!empty($entity->filename) && 
    preg_match('/^(?P<creation_date>\d{4}-\d{2}-\d{2})\/(?P<id>\d*)_(?P<fname>.*?)\.(?P<ext>.{3,4})$/', $entity->filename, $matches))
<div class="datatable-image-wrapper" 
        data-photo-id="{{ $entity->id }}" 
        data-photo-thumb-size-id="{{ $thumbSize }}" 
        data-photo-thumb-params="{{ json_encode($entity->thumb_params) }}"
        data-photo-width="{{ $entity->width }}"
        data-photo-height="{{ $entity->height }}"
        data-photo-source="{{ $entity->source }}"
        data-photo-signature="{{ $entity->alt }}"
        data-photo-filename="{{ basename($entity->filename) }}"
        data-photo-category-id="{{ $entity->category }}"
        data-photo-licence-id="{{ $entity->licence_id }}"
        data-photo-licence-name="{{ $entity->licence_name }}"
        data-photo-created-at="{{ $entity->getDatetimeColumnFormatted('created_at') }}"
        data-photo-updated-at="{{ $entity->getDatetimeColumnFormatted('updated_at') }}"
        data-photo-creation-date="{{ $entity->creation_date }}"
        data-photo-creation-user-id="{{ $entity->creation_user }}"
        data-photo-mod-user-id="{{ $entity->mod_user }}"
        data-photo-pristine-img-src="{{ $entity->getImgSrcPath() . $timestamp }}" 
        data-photo-source-img-src="{{ $entity->getSourceImgSrcPath($thumbSize) . $timestamp }}" 
        data-photo-img-src="{{ $entity->getImgSrcPath($thumbSize) . $timestamp }}" 
        data-photo-img-src-template="{{ $entity->getImgSrcTemplate() }}"
        data-photo-template-placeholder="{{ $entity::DEFAULT_TEMPLATE_PLACEHOLDER }}"
        data-photo-tags-ids="{{ $entity->tags->pluck('id') }}"
        data-photo-all-img-sources="{{ $entity->getAllThumbsImgSrcs('JSON', TRUE) }}" 
    >
    <img 
        src="{{ $entity->getImgSrcPath($thumbSize) . $timestamp }}" 
        alt=""
        data-photo-action="show" 
    >
    <div class="gallery-img-buttons">
        <a  href="{{ $entity->getImgSrcPath($thumbSize) }}" 
            class="gallery-img-btn" 
            title="Download"
            download 
            >
            <i class="fa fa-download"></i></a>
        <a  href="javascript:;" 
            class="gallery-img-btn" 
            title="@lang('Izmeni')"
            data-photo-action="edit" 
            >
            <i class="fa fa-pencil"></i></a>
        <a  href="javascript:;" 
            class="gallery-img-btn" 
            title="@lang('Izbriši')"
            data-photo-action="delete" 
            data-title="@lang('Izbriši')"
            data-id="{{ $entity->id }}"
            data-text="@lang('Da li ste sigurni da želite da obrišete sliku #~b~#')"
            data-label="{{ $entity->filename }}"
            data-ajax-url="{{ route('media.library.delete', $entity->id) }}"
            >
            <i class="fa fa-trash"></i></a>
    </div>
</div>
@endif

