@extends('_layout.layout')

@section('head_title', __('Pregled / Izmena Profila') . ' - ' . __('Profil') . ' - ' . __('Podesavanja'))

@push('head_links')
    <link href="{{ asset('/theme/plugins/bootstrap-select/css/bootstrap-select.min.css') }}" rel="stylesheet"> 
    <link href="{{ asset('/theme/plugins/bootstrap-tagsinput/css/bootstrap-tagsinput.css') }}" rel="stylesheet">
    <style>
        .contact-detail {
            border-bottom: 1px solid whitesmoke;
        }
        .bootstrap-tagsinput {
            border: none !important;
            cursor: default;
        }
        .tag.badge.badge-info > span {
            display: none; !important;
        }
        .bootstrap-tagsinput input {
            cursor: default; 
        }
    </style>
@endpush

@section('content')



<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Profil')</h3>
                    <p class="card-sub-title text-muted">
                        &nbsp;
                    </p>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('profile.edit_password')}}" class="btn btn-warning">
                        <i class="fa fa-user-secret"></i>
                        @lang('Izmeni Lozinku')
                    </a>
                    <a href="{{route('truck.invoices')}}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i>
                        @lang('Nazad')
                    </a>
                </div>
            </div>

            <div class="card-body">
                <div class="row justify-content-around">
                    <!-- PROFIL INFO START -->
                    <div class="col-lg-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="text-center member-box">
                                    <div class="member-card">
                                        <div class="thumb-xl member-thumb m-b-10 mx-auto d-block">
                                            <img src="{{ auth()->user()->getProfileImg() ?? config('newscms.default_profile_img_src') }}" class="rounded-circle img-thumbnail" alt="{{ __('Profilna slika') }}">
                                            <i class="mdi mdi-star-circle member-star text-muted" title="unverified user"></i>
                                        </div>

                                        <div>
                                            <h4 class="m-b-5">{{ auth()->user()->getFullName() }}</h4>
                                            <p class="mb-3"><span class="text-pink"></span></p>
                                        </div>

                                        <div class="contact-box">

                                            <div class="contact-detail">
                                                <i class=" mdi mdi-cellphone-iphone"></i>
                                                @if(auth()->user()->phone)
                                                    {{ auth()->user()->phone }}
                                                @else
                                                    &nbsp;
                                                @endif
                                            </div>

                                            <div class="contact-detail">
                                                <i class="mdi mdi-email"></i>
                                                {{ auth()->user()->email }}
                                            </div>

                                        </div>

                                        <p class="text-muted">@lang('Svi website-ovi nad kojima je dozvoljen pristup:')</p>
                                        <div class="m-b-0">
                                            <select multiple data-role="tagsinput" class="d-none" disabled>
                                                @foreach( auth()->user()->getWebsites() as $website )
                                                    <option value="{{ $website->short_title }}">{{ $website->short_title }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>                
                    <!-- PROFIL INFO KRAJ -->

                    <!-- IZMENA PODATAKA START -->
                    <div class="col-lg-7 d-flex align-items-center">
                        @include('profile.partials.form')
                    </div>
                    <!-- IZMENA PODATAKA KRAJ -->
                </div> <!-- end row -->
            </div> <!-- end card-body -->

        </div> <!-- end card -->
    </div>
</div>

@endsection

@push('footer_scripts')
<script src="{{ asset('/theme/plugins/bootstrap-select/js/bootstrap-select.min.js') }}"></script>
<script src="{{ asset('/theme/plugins/bootstrap-tagsinput/js/bootstrap-tagsinput.min.js') }}"></script>
<script>
$(function() {
    // onemogucava 'mouse click' nad 'select tags' elementom (sve poslovne jedinice) 
    // zbog prikaza kursora koji ne bi trebalo da se prikazuje.
    $('.bootstrap-tagsinput input').prop('disabled', true);
});
</script>
@endpush