@extends('auth._layout.layout')

@section('head_title', __('Izmena lozinke'))

@section('content')

    <form class="form-horizontal" method="post" action="" autocomplete="off">
            @csrf       
            <div class="form-group m-b-25">
                <div class="col-12">
                    <label for="old_password">@lang('Lozinka')</label>
                    <input id="old_password" 
                           name="old_password" 
                           class="form-control input-lg @errorClass('old_password', 'is-invalid')" 
                           type="password" 
                           placeholder="{{ __('Trenutna Lozinka') }}" 
                           tabindex="1" 
                           required
                           autofocus
                           >
                    @include('_layout.partials.form.error', ['field' => 'old_password'])
                </div>
            </div>

            <div class="form-group m-b-25">
                <div class="col-12">
                    <label for="password">@lang('Nova lozinka')</label>
                    <input id="password" 
                           name="password" 
                           class="form-control input-lg @errorClass('password', 'is-invalid')" 
                           type="password" 
                           placeholder="{{ __('Nova lozinka') }}" 
                           tabindex="1" 
                           required
                           autofocus
                           >
                    @include('_layout.partials.form.error', ['field' => 'password'])
                </div>
            </div>

            <div class="form-group m-b-25">
                <div class="col-12">
                    <label for="password_confirmation">@lang('Potvrda nove lozinke')</label>
                    <input id="password_confirmation" 
                           name="password_confirmation" 
                           class="form-control input-lg @errorClass('password_confirmation', 'is-invalid')" 
                           type="password" 
                           placeholder="{{ __('Potvrda nove lozinke') }}" 
                           tabindex="1" 
                           required
                           autofocus
                           >
                    @include('_layout.partials.form.error', ['field' => 'password_confirmation'])
                </div>
            </div>

            <div class="form-group account-btn text-center m-t-10">
                <div class="col-12">
                    <button class="btn w-lg btn-rounded btn-lg btn-warning waves-effect waves-light mx-4" type="submit">@lang('Izmeni')</button>
                    <a href="{{ route('profile.edit') }}" class="btn w-lg btn-rounded btn-lg btn-danger waves-effect waves-light mx-4">@lang('Odustani')</a>
                </div>
            </div>

        </form>

        <div class="clearfix"></div>

@endsection
