@extends('_layout.layout')

@section('head_title', __('Izlana Faktura') . ' - ' . __('Kreiranje Fakture'))

@push('head_links')

@endpush

@section('content')

@include('_layout.partials.breadcrumbs', [
    'pageTitle' => __("Kreiranje izlazne fakture"),
    'breadcrumbs' => [
        route('truck.invoices') => __('Izlazne Fakture')
    ]
])

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-heading d-flex justify-content-between">
                <div class="card-heading-title">
                    <h3 class="card-title">@lang('Kreiranje nove fakture')</h3>
                    <p class="card-sub-title text-muted">@lang('Sva polja su obavezna')</p>
                </div>
                <div class="card-heading-actions">
                    <a href="{{route('truck.invoices')}}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i>
                        @lang('Nazad')
                    </a>
                </div>
            </div>
            <div class="card-body">
                @include('truck.invoices.partials.form', ['entity' => $entity])
            </div>
        </div>
    </div>
</div>

@endsection
