@push('head_links')
<link href="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.css')}}" rel="stylesheet" />
@endpush

<style>
    .spacer {
        margin-top: 8px;
    }

    .form-group {
        margin-bottom: 16px;
    }

    .date-yellow {
    background-color: yellow;
    }

    .date-red {
        background-color: red;
        color: white;
    }
</style>

<form id="entity-form" class="form-horizontal" method="post" action="" 
      enctype="multipart/form-data" autocomplete="off">
    <div class="row">
        <div class="col-lg-7 align-self-center">
            @csrf
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Proizvodjač')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('producer', 'is-invalid')" 
                        name="producer" 
                        placeholder="@lang('Proizvodjač')" 
                        value="{{old('producer', $entity->producer)}}"
                    >
                    @formError(['field' => 'producer'])
                    
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Naziv vozila')<sup>*</sup></label>
                <div class="col-sm-9">
                    <input 
                        type="text" 
                        class="form-control @errorClass('name', 'is-invalid')" 
                        name="name" 
                        placeholder="@lang('Naziv vozila')" 
                        value="{{old('name', $entity->name)}}"
                    >
                    @formError(['field' => 'name'])
                    
                </div>
            </div>
            
            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Broj saobraćajne')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('phone', 'is-invalid')" 
                        name="traffic_number" 
                        placeholder="@lang('Broj saobraćajne')" 
                        value="{{old('traffic_number', $entity->traffic_number)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-credit-card"></i>
                        </span>
                    </span>
                    @formError(['field' => 'traffic_number'])
                    
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 control-label">@lang('Tablice')</label>
                <div class="col-sm-9 input-group">
                    <input 
                        type="text" 
                        class="form-control @errorClass('number_of_plates', 'is-invalid')" 
                        name="number_of_plates" 
                        placeholder="@lang('Tablice')" 
                        value="{{old('number_of_plates', $entity->number_of_plates)}}"
                    >
                    <span class="input-group-addon bootstrap-touchspin-postfix input-group-append">
                        <span class="input-group-text">
                            <i class="fa fa-solid fa-truck"></i>
                        </span>
                    </span>
                    @formError(['field' => 'number_of_plates'])
                    
                </div>
            </div>
            
        </div>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

        <div class="col-lg-5 d-flex justify-content-center align-items-center">
            <div class="d-flex align-items-center">
                <i class="fas fa-gas-pump fa-3x me-4"></i> 
                <div style="margin:30px;">
                    <h5>@lang('Potrošnja goriva')</h5>
                    <p>@lang('Mesečna potrošnja'): <strong>000 L</strong></p>
                    <p>@lang('Godišnja potrošnja'): <strong>000 L</strong></p>
                </div>
            </div>
        </div>
    </div>
    <hr>

    <div class="row">
        <!-- Registracija -->
        <div class="col-lg-3">
            <div class="form-group">
                <label class="control-label">@lang('Registracija')</label>
                <input type="text" class="form-control text-center enterable" name="registracija_start" id="registracija_start" placeholder="@lang('Datum')" value="{{ old('registracija_start', !empty($entity->registracija_start) ? date('d-m-Y', strtotime($entity->registracija_start)) : "") }}">
                @formError(['field' => 'registracija_start'])
                <div class="spacer"></div>
                <input type="text" class="form-control text-center enterable" name="registracija_end" id="registracija_end" placeholder="@lang('Datum')" value="{{ old('registracija_end', !empty($entity->registracija_end) ? date('d-m-Y', strtotime($entity->registracija_end)) : "") }}">
                @formError(['field' => 'registracija_end'])
            </div>
        </div>
        <!-- Sestomesecni -->
        <div class="col-lg-3">
            <div class="form-group">
                <label class="control-label">@lang('Sestomesecni')</label>
                <input type="text" class="form-control text-center enterable" name="sestomjesecni_start" id="sestomjesecni_start" placeholder="@lang('Datum')" value="{{ old('sestomjesecni_start', !empty($entity->sestomjesecni_start) ? date('d-m-Y', strtotime($entity->sestomjesecni_start)) : "") }}">
                @formError(['field' => 'sestomjesecni_start'])
                <div class="spacer"></div>
                <input type="text" class="form-control text-center enterable" name="sestomjesecni_end" id="sestomjesecni_end" placeholder="@lang('Datum')" value="{{ old('sestomjesecni_end', !empty($entity->registracija_end) ? date('d-m-Y', strtotime($entity->sestomjesecni_end)) : "") }}">
                @formError(['field' => 'sestomjesecni_end'])
            </div>
        </div>
        <!-- PP Aparati -->
        <div class="col-lg-3">
            <div class="form-group">
                <label class="control-label">@lang('PP Aparati')</label>
                <input type="text" class="form-control text-center enterable" name="pp_start" id="pp_start" placeholder="@lang('Datum')" value="{{ old('pp_start', !empty($entity->pp_start) ? date('d-m-Y', strtotime($entity->pp_start)) : "") }}">
                @formError(['field' => 'pp_start'])
                <div class="spacer"></div>
                <input type="text" class="form-control text-center enterable" name="pp_end" id="pp_end" placeholder="@lang('Datum')" value="{{ old('pp_end', !empty($entity->pp_end) ? date('d-m-Y', strtotime($entity->pp_end)) : "") }}">
                @formError(['field' => 'pp_end'])
            </div>
        </div>
        <!-- Tahograf -->
        <div class="col-lg-3">
            <div class="form-group">
                <label class="control-label">@lang('Tahograf')</label>
                <input type="text" class="form-control text-center enterable" name="tahograf_start" id="tahograf_start" placeholder="@lang('Datum')" value="{{ old('tahograf_start', !empty($entity->tahograf_start) ? date('d-m-Y', strtotime($entity->tahograf_start)) : "") }}">
                @formError(['field' => 'tahograf_start'])
                <div class="spacer"></div>
                <input type="text" class="form-control text-center enterable" name="tahograf_end" id="tahograf_end" placeholder="@lang('Datum')" value="{{ old('tahograf_end', !empty($entity->tahograf_end) ? date('d-m-Y', strtotime($entity->tahograf_end)) : "") }}">
                @formError(['field' => 'tahograf_end'])
            </div>
        </div>
    </div>
    
    <style>
        .spacer {
            margin-top: 8px;
        }
    </style>
    
    
    <hr>
    <div class="form-group row">
        <div class="col-sm-9">
            <button type="submit" class="btn btn-success waves-effect waves-light">
                <i class="fa fa-save"></i>
                @lang('Sačuvaj')
            </button>
        </div>
    </div>
</form>

@push('footer_scripts')
<script src="{{asset('/theme/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js')}}"></script>
<script src="{{asset('/theme/plugins/bootstrap-jasny/bootstrap-jasny.min.js')}}"></script>
<script>
$(function() {

    $(document).ready(function() {
    // Initialize datepickers with the specified format and options
    $('input[name$="_start"], input[name$="_end"]').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        todayHighlight: true
    });

    // Custom validator to ensure date_start is not greater than date_end
    $.validator.addMethod("greaterStart", function(value, element, params) {
        let startDate = $(params[0]).val().split("-");
        let endDate = $(params[1]).val().split("-");
        let start = new Date(startDate[2], startDate[1] - 1, startDate[0]);
        let end = new Date(endDate[2], endDate[1] - 1, endDate[0]);
        return this.optional(element) || start <= end;
    }, "{{ __('Datum mora biti veći od datuma početka.') }}");

    // Apply validation rules
    $("#entity-form").validate({
        rules: {
            registracija_end: { greaterStart: ['#registracija_start', '#registracija_end'] },
            sestomjesecni_end: { greaterStart: ['#sestomjesecni_start', '#sestomjesecni_end'] },
            pp_end: { greaterStart: ['#pp_start', '#pp_end'] },
            tahograf_end: { greaterStart: ['#tahograf_start', '#tahograf_end'] }
        }
    });
});

    $(document).ready(function() {
        // Funkcija koja proverava datum i menja boju inputa
        function applyDateColor(inputId, dateStr) {
            var today = moment(); // trenutni datum
            var dateEnd = moment(dateStr, 'D-M-YYYY'); // parsiramo datum iz inputa

            if (!dateEnd.isValid()) return; // ako datum nije validan, ne radimo ništa

            // Uklanjamo prethodne klase
            $('#' + inputId).removeClass('date-yellow date-red');

            // Ako je datum istekao ili je danas
            if (today.isSameOrAfter(dateEnd, 'day')) {
                $('#' + inputId).addClass('date-red'); // postavljamo crvenu boju
            }
            // Ako je datum u poslednjih 7 dana
            else if (today.isSameOrAfter(dateEnd.clone().subtract(7, 'days'), 'day') && today.isBefore(dateEnd, 'day')) {
                $('#' + inputId).addClass('date-yellow'); // postavljamo žutu boju
            }
        }

        // Proveravamo datum za svaki relevantni input
        applyDateColor('registracija_end', $('#registracija_end').val());
        applyDateColor('sestomjesecni_end', $('#sestomjesecni_end').val());
        applyDateColor('pp_end', $('#pp_end').val());
        applyDateColor('tahograf_end', $('#tahograf_end').val());

        // Event listener za promenu datuma, kako bi se boje ažurirale ako korisnik menja datum
        $('#registracija_end, #sestomjesecni_end, #pp_end, #tahograf_end').on('change', function() {
            applyDateColor(this.id, $(this).val());
        });
    });

    
    $(document).ready(function() {
    $('#entity-form').validate({
        rules: {
            producer: {
                required: true
            },
            name: {
                required: true
            },
            traffic_number: {
                required: true,
                maxlength: 20
            },
            tahograf_start: {
                required: true,
                date: true
            },
            tahograf_end: {
                required: true,
                date: true
            }
        },
        messages: {
            
        },
    });
});

});
</script>
@endpush