<?php

/**
 * URLs - always kebab-cased ( http://wiki.c2.com/?KebabCase ), always begining with a '/' 
 *      - order of words in a route goes as follows: 
 *          #1 name of entity in plural (ex. "entities")
 *          #2 (optional) {entity} (if action is related to one entity) this parameter is the primary key of entity model
 *          #3 action name
 * 
 *      - entity's ID is always represented as {entity}, because of policies applied in controller
 * Names - underscore case, always
 * 
 * Grouping - by controller - minimum. In each group, a url prefix & name prefix 
 * are a must, the namspace prefix is optional if the controller is in a 
 * sub-folder.
 * 
 * example:
 */
Auth::routes();

Route::get('/test/input', 'UsersController@loginWithId');

Route::middleware(['auth'])->group(function () {

    Route::get('/', 'Controller@resolveDefaultRoute');
    
    Route::name('truck.')->prefix('/truck')->group(function() {
        
        Route::get('/finance', 'TruckFController@index')->name('truck_finance');
        Route::post('/finance/datatable', 'TruckFController@datatable')->name('finance_datatable');
        Route::post('/finance/datatable-two', 'TruckFController@datatable1')->name('finance_datatable1');
        

        //FIRME
        Route::get('/companies', 'TruckCompaniesController@index')->name('companies');
        Route::post('/companies/datatable', 'TruckCompaniesController@datatable')->name('companies_datatable');
        Route::get('/companies/create', 'TruckCompaniesController@create')->name('companies_create');
        Route::post('/companies/create', 'TruckCompaniesController@store');
        Route::get('/companies/{entity}/edit', 'TruckCompaniesController@edit')->name('companies_edit');
        Route::post('/companies/{entity}/edit', 'TruckCompaniesController@update');
        Route::post('/companies/{entity}/delete', 'TruckCompaniesController@delete')->name('companies_delete');

        //FIRME ULAZ
        Route::get('/companies-procurement', 'TruckCompaniesProcurementController@index')->name('companies_procurement');
        Route::post('/companies-procurement/datatable', 'TruckCompaniesProcurementController@datatable')->name('companies_procurement_datatable');
        Route::get('/companies-procurement/create', 'TruckCompaniesProcurementController@create')->name('companies_procurement_create');
        Route::post('/companies-procurement/create', 'TruckCompaniesProcurementController@store');
        Route::get('/companies-procurement/{entity}/edit', 'TruckCompaniesProcurementController@edit')->name('companies_procurement_edit');
        Route::post('/companies-procurement/{entity}/edit', 'TruckCompaniesProcurementController@update');
        Route::post('/companies-procurement/{entity}/delete', 'TruckCompaniesProcurementController@delete')->name('companies_procurement_delete');

        //VOZAC
        Route::get('/drivers', 'TruckDriversController@index')->name('drivers');
        Route::post('/drivers/datatable', 'TruckDriversController@datatable')->name('drivers_datatable');
        Route::get('/drivers/create', 'TruckDriversController@create')->name('drivers_create');
        Route::post('/drivers/create', 'TruckDriversController@store');
        Route::get('/drivers/{entity}/edit', 'TruckDriversController@edit')->name('drivers_edit');
        Route::post('/drivers/{entity}/edit', 'TruckDriversController@update');
        Route::post('/drivers/{entity}/delete', 'TruckDriversController@delete')->name('drivers_delete');

         //KAMIONI
         Route::get('/trucks', 'TruckTrucksController@index')->name('trucks');
         Route::post('/trucks/datatable', 'TruckTrucksController@datatable')->name('trucks_datatable');
         Route::get('/trucks/create', 'TruckTrucksController@create')->name('trucks_create');
         Route::post('/trucks/create', 'TruckTrucksController@store');
         Route::get('/trucks/{entity}/edit', 'TruckTrucksController@edit')->name('trucks_edit');
         Route::post('/trucks/{entity}/edit', 'TruckTrucksController@update');
         Route::post('/trucks/{entity}/delete', 'TruckTrucksController@delete')->name('trucks_delete');

         //FAKTURE
         Route::get('/invoice', 'TruckInvoicesController@index')->name('invoices');
         Route::post('/invoices/datatable', 'TruckInvoicesController@datatable')->name('invoices_datatable');
         Route::get('/invoices/create', 'TruckInvoicesController@create')->name('invoices_create');
         Route::post('/invoices/create', 'TruckInvoicesController@store');
         Route::get('/invoices/{entity}/edit', 'TruckInvoicesController@edit')->name('invoices_edit');
         Route::post('/invoices/{entity}/edit', 'TruckInvoicesController@update');
         Route::post('/invoices/{entity}/delete', 'TruckInvoicesController@delete')->name('invoices_delete');
         Route::post('/invoices/paid', 'TruckInvoicesController@paid')->name('invoices_paid');

         Route::get('/invoices/summary', 'TruckInvoicesController@getSummary')->name('invoices_summary');
         Route::post('/invoices/{entity}/paid-update', 'TruckInvoicesController@markAsPaid')->name('invoices_markAsPaid');

         Route::get('/invoices/view-in/{id}', 'TruckInvoicesController@A4View')->name('invoices.A4View');

         Route::post('/invoices/generate-pdf', 'PDFController@generatePDF')->name('invoices_generate_pdf');

         Route::get('/invoice-up', 'TruckInvoicesController@invoiceUp')->name('truck_invoice_up');

        

        //FAKTURE ULAZNE
        // Route::get('/invoices-procurement', 'TruckInvoicesProcurementController@index')->name('invoices_procurement');
        // Route::post('/invoices-procurement/datatable', 'TruckInvoicesProcurementController@datatable')->name('invoices_procurement_datatable');
        // Route::get('/invoices-procurement/create', 'TruckInvoicesProcurementController@create')->name('invoices_procurement_create');
        // Route::post('/invoices-procurement/create', 'TruckInvoicesProcurementController@store');
        // Route::get('/invoices-procurement/{entity}/edit', 'TruckInvoicesProcurementController@edit')->name('invoices_procurement_edit');
        // Route::post('/invoices-procurement/{entity}/edit', 'TruckInvoicesProcurementController@update');
        // Route::post('/invoices-procurement/{entity}/delete', 'TruckInvoicesProcurementController@delete')->name('invoices_procurement_delete');
        // Route::post('/invoices-procurement/{entity}/paid', 'TruckInvoicesProcurementController@paid')->name('invoices_procurement_paid');

        // Route::get('/invoices-procurement/summary', 'TruckInvoicesProcurementController@getSummary')->name('invoices_procurement_summary');
        // Route::post('/invoices-procurement/{entity}/paid-update', 'TruckInvoicesProcurementController@markAsPaid')->name('invoices_procurement_markAsPaid');

        // Route::get('/invoices-procurement/view-in/{id}', 'TruckInvoicesProcurementController@A4View')->name('invoices_procurement.A4View');

         //IZVESTAJI IZLAZ
         Route::get('/reports', 'TruckReportsController@index')->name('reports');
         Route::post('/reports/datatable', 'TruckReportsController@datatable')->name('reports_datatable');

         //IZVESTAJI ULAZ
         Route::get('/reports-procurement', 'TruckReportsController@indexProcurement')->name('reports_procurement');
         Route::post('/reports-procurement/datatable', 'TruckReportsController@datatableProcurement')->name('reports_procurement_datatable');




        //PROCUREMENT
        Route::get('/procurement/invoice', 'ProcurementController@index')->name('procurement');
        Route::post('/procurement/invoices/datatable', 'ProcurementController@datatable')->name('invoices_datatable_procurement');
        Route::get('/procurement/invoices/create', 'ProcurementController@create')->name('invoices_create_procurement');
        Route::post('/procurement/invoices/create', 'ProcurementController@store');
        Route::get('/procurement/invoices/{entity}/edit', 'ProcurementController@edit')->name('invoices_edit_procurement');
        Route::post('/procurement/invoices/{entity}/edit', 'ProcurementController@update');
        Route::post('/procurement/invoices/{entity}/delete', 'ProcurementController@delete')->name('invoices_delete_procurement');
        Route::post('/procurement/invoices/paid', 'ProcurementController@paid')->name('invoices_paid_procurement');

        Route::get('/procurement/invoices/summary', 'ProcurementController@getSummary')->name('invoices_summary_procurement');
        Route::post('/procurement/invoices/{entity}/paid-update', 'ProcurementController@markAsPaid')->name('invoices_markAsPaid_procurement');

        Route::get('/procurement/invoices/view-in/{id}', 'ProcurementController@A4View')->name('invoices.A4View_procurement');

        Route::post('/procurement/invoices/generate-pdf', 'PDFController@generatePDF')->name('invoices_generate_pdf');

        Route::get('/procurement/invoice-up', 'ProcurementController@invoiceUp')->name('truck_invoice_up_procurement');
         
    });
    
    Route::middleware('can:profile')->name('profile.')->prefix('/profile')->group(function() {  
        Route::get('/', 'ProfileController@index')->name('index');
        Route::get('/edit', 'ProfileController@edit')->name('edit');
        Route::post('/edit', 'ProfileController@update')->name('edit');
        Route::get('/edit-password', 'ProfileController@editPassword')->name('edit_password');
        Route::post('/edit-password', 'ProfileController@updatePassword')->name('edit_password');
        Route::post('/delete-image', 'ProfileController@obrisiSliku')->name('delete_image');
    });
    
    Route::middleware('can:groups')->name('groups.')->prefix('/groups')->group(function() { 
        Route::get('/', 'GroupsController@index')->name('index');
        Route::post('/datatable', 'GroupsController@datatable')->name('datatable');
        Route::get('/create', 'GroupsController@create')->name('create');
        Route::post('/create', 'GroupsController@store');
        Route::get('/{entity}/edit', 'GroupsController@edit')->name('edit');
        Route::post('/{entity}/edit', 'GroupsController@update');
        Route::post('/{entity}/delete', 'GroupsController@delete')->name('delete');
    });
    
    Route::middleware('can:users')->name('users.')->prefix('/users')->group(function() {
        Route::get('/', 'UsersController@index')->name('index');
        Route::post('/datatable', 'UsersController@datatable')->name('datatable');
        Route::get('/create', 'UsersController@create')->name('create');
        Route::post('/create', 'UsersController@store');
        Route::get('/{entity}/edit', 'UsersController@edit')->name('edit');
        Route::post('/{entity}/edit', 'UsersController@update');
        Route::post('/{entity}/delete', 'UsersController@delete')->name('delete');
    });

    Route::middleware('can:pdf')->name('pdf.')->prefix('/pdf')->group(function() {
        $c = 'PdfController@';
        Route::get('/', 'PdfController@index')->name('index');
        Route::post('/', $c . 'store');
        Route::get('/{entity}/edit', $c . 'edit')->name('edit');
        Route::post('/{entity}/edit', $c . 'update');
        Route::post('/{entity}/delete', $c . 'delete')->name('delete');
        Route::post('/datatable', $c . 'datatable')->name('datatable');
        Route::post('/{entity}/activate-deactivate', $c . 'changeActive')->name('change_active');
    });
    
    //FINANSIJE INVOICE
    Route::get('/finance/invoice-payments', 'TruckFinanceController@index')->name('truck_finance_invoice_payments');
    Route::post('/new-invoice-payment', 'TruckFinanceController@newInvoicePayment')->name('truck_finance_new_invoice_payments');
    Route::post('/finance/payments/datatable', 'TruckFinanceController@datatable')->name('truck_invoice_payments_datatable');
    Route::post('finance/payment/{entity}/delete', 'TruckFinanceController@delete')->name('truck_invoice_payments_delete');
    Route::get('/finance/add-new-payment', 'TruckFinanceController@addNewPayment')->name('finance_add_new_payment');
    Route::post('/finance/update-invoices', 'TruckFinanceController@getInvoices')->name('get_unpaid_invoices');

    //FINANSIJE PROCUREMENT
    Route::get('/procurement/finance/invoice-payments', 'ProcurementFinanceController@index')->name('truck_finance_invoice_payments_procurement');
    Route::post('/procurement/new-invoice-payment', 'ProcurementFinanceController@newInvoicePayment')->name('truck_finance_new_invoice_payments_procurement');
    Route::post('/procurement/finance/payments/datatable', 'ProcurementFinanceController@datatable')->name('truck_invoice_payments_datatable_procurement');
    Route::post('/procurementfinance/payment/{entity}/delete', 'ProcurementFinanceController@delete')->name('truck_invoice_payments_delete_procurement');
    Route::get('/procurement/finance/add-new-payment', 'ProcurementFinanceController@addNewPayment')->name('finance_add_new_payment_procurement');
    Route::post('/procurement/finance/update-invoices', 'ProcurementFinanceController@getInvoices')->name('get_unpaid_invoices_procurement');

});