<div class="card">
    <div class="card-heading d-flex justify-content-between">
        <div class="card-heading-title">
            <h3 class="card-title"><?php echo app('translator')->get('Lista Uplata'); ?></h3>
            <p class="card-sub-title text-muted"><?php echo app('translator')->get('Postoji <code>pretraga</code> liste'); ?></p>
        </div>
        <div class="card-heading-actions">

        </div>
    </div>
    <div class="card-body">
        <table id="entities-table" class="table table-striped">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Klijent'); ?></th>
                    <th><?php echo app('translator')->get('Datum'); ?></th>
                    <th><?php echo app('translator')->get('Referentni broj'); ?></th>
                    <th><?php echo app('translator')->get('Cena'); ?></th>
                </tr>
            </thead>

        </table>
    </div>
</div>

<?php $__env->startPush('footer_scripts'); ?>
<script>
$(function(){

    $('#entities-table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            url: "<?= route('truck_invoice_payments_datatable'); ?>",
            type: "POST",
            data: {entityId: "<?php echo e($entity->id); ?>"}
        },
        "columns": [
            {"data": "company", className: "text-left"},
            {"data": "date_start", "searchebale": false, "orderable": false},
            {"data": "reference", "searchebale": false, "orderable": false},
            {"data": "price", "searchebale": false, "orderable": false, className: "text-right"},
        ]
    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="delete"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="enable"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });

    $('#entities-table').questionPop({
        "liveSelector": '[data-action="disable"]'
    }).on('success.qp', function() {
        $('#entities-table').DataTable().draw('page');

    });


});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/drventar/vd-trans.com/fakture/resources/views/truck/finance/partials/list.blade.php ENDPATH**/ ?>